package physx.extensions;

import physx.NativeObject;
import physx.vehicle.PxVehicleWheels;
import physx.vehicle.PxWheelQueryResult;

public class BatchVehicleUpdate extends NativeObject {

    protected BatchVehicleUpdate() { }

    public static BatchVehicleUpdate wrapPointer(long address) {
        return address != 0L ? new BatchVehicleUpdate(address) : null;
    }
    
    protected BatchVehicleUpdate(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param desc WebIDL type: {@link BatchVehicleUpdateDesc} [Ref]
     */
    public BatchVehicleUpdate(BatchVehicleUpdateDesc desc) {
        address = _BatchVehicleUpdate(desc.getAddress());
    }
    private static native long _BatchVehicleUpdate(long desc);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param vehicle WebIDL type: {@link PxVehicleWheels}
     */
    public void addVehicle(PxVehicleWheels vehicle) {
        checkNotNull();
        _addVehicle(address, vehicle.getAddress());
    }
    private static native void _addVehicle(long address, long vehicle);

    /**
     * @param vehicle WebIDL type: {@link PxVehicleWheels}
     */
    public void removeVehicle(PxVehicleWheels vehicle) {
        checkNotNull();
        _removeVehicle(address, vehicle.getAddress());
    }
    private static native void _removeVehicle(long address, long vehicle);

    public void removeAllVehicles() {
        checkNotNull();
        _removeAllVehicles(address);
    }
    private static native void _removeAllVehicles(long address);

    /**
     * @param vehicle WebIDL type: {@link PxVehicleWheels}
     * @return WebIDL type: long
     */
    public int indexOf(PxVehicleWheels vehicle) {
        checkNotNull();
        return _indexOf(address, vehicle.getAddress());
    }
    private static native int _indexOf(long address, long vehicle);

    /**
     * @param timestep WebIDL type: float
     */
    public void batchUpdate(float timestep) {
        checkNotNull();
        _batchUpdate(address, timestep);
    }
    private static native void _batchUpdate(long address, float timestep);

    /**
     * @param vehicleId WebIDL type: unsigned long
     * @param wheelId   WebIDL type: unsigned long
     * @return WebIDL type: {@link PxWheelQueryResult}
     */
    public PxWheelQueryResult getWheelQueryResult(int vehicleId, int wheelId) {
        checkNotNull();
        return PxWheelQueryResult.wrapPointer(_getWheelQueryResult(address, vehicleId, wheelId));
    }
    private static native long _getWheelQueryResult(long address, int vehicleId, int wheelId);

}
