package physx.geomutils;

import physx.NativeObject;
import physx.common.PxBase;
import physx.common.PxVec3;

public class PxHeightField extends PxBase {

    protected PxHeightField() { }

    public static PxHeightField wrapPointer(long address) {
        return address != 0L ? new PxHeightField(address) : null;
    }
    
    protected PxHeightField(long address) {
        super(address);
    }

    // Functions

    /**
     * @param destBuffer     WebIDL type: VoidPtr
     * @param destBufferSize WebIDL type: unsigned long
     * @return WebIDL type: unsigned long
     */
    public int saveCells(NativeObject destBuffer, int destBufferSize) {
        checkNotNull();
        return _saveCells(address, destBuffer.getAddress(), destBufferSize);
    }
    private static native int _saveCells(long address, long destBuffer, int destBufferSize);

    /**
     * @param startCol     WebIDL type: long
     * @param startRow     WebIDL type: long
     * @param subfieldDesc WebIDL type: {@link PxHeightFieldDesc} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean modifySamples(int startCol, int startRow, PxHeightFieldDesc subfieldDesc) {
        checkNotNull();
        return _modifySamples(address, startCol, startRow, subfieldDesc.getAddress());
    }
    private static native boolean _modifySamples(long address, int startCol, int startRow, long subfieldDesc);

    /**
     * @param startCol     WebIDL type: long
     * @param startRow     WebIDL type: long
     * @param subfieldDesc WebIDL type: {@link PxHeightFieldDesc} [Const, Ref]
     * @param shrinkBounds WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean modifySamples(int startCol, int startRow, PxHeightFieldDesc subfieldDesc, boolean shrinkBounds) {
        checkNotNull();
        return _modifySamples(address, startCol, startRow, subfieldDesc.getAddress(), shrinkBounds);
    }
    private static native boolean _modifySamples(long address, int startCol, int startRow, long subfieldDesc, boolean shrinkBounds);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbRows() {
        checkNotNull();
        return _getNbRows(address);
    }
    private static native int _getNbRows(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbColumns() {
        checkNotNull();
        return _getNbColumns(address);
    }
    private static native int _getNbColumns(long address);

    /**
     * @return WebIDL type: {@link PxHeightFieldFormatEnum} [enum]
     */
    public int getFormat() {
        checkNotNull();
        return _getFormat(address);
    }
    private static native int _getFormat(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getSampleStride() {
        checkNotNull();
        return _getSampleStride(address);
    }
    private static native int _getSampleStride(long address);

    /**
     * @return WebIDL type: float
     */
    public float getConvexEdgeThreshold() {
        checkNotNull();
        return _getConvexEdgeThreshold(address);
    }
    private static native float _getConvexEdgeThreshold(long address);

    /**
     * @return WebIDL type: {@link PxHeightFieldFlags} [Value]
     */
    public PxHeightFieldFlags getFlags() {
        checkNotNull();
        return PxHeightFieldFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param x WebIDL type: float
     * @param z WebIDL type: float
     * @return WebIDL type: float
     */
    public float getHeight(float x, float z) {
        checkNotNull();
        return _getHeight(address, x, z);
    }
    private static native float _getHeight(long address, float x, float z);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getReferenceCount() {
        checkNotNull();
        return _getReferenceCount(address);
    }
    private static native int _getReferenceCount(long address);

    public void acquireReference() {
        checkNotNull();
        _acquireReference(address);
    }
    private static native void _acquireReference(long address);

    /**
     * @param triangleIndex WebIDL type: unsigned long
     * @return WebIDL type: unsigned short
     */
    public short getTriangleMaterialIndex(int triangleIndex) {
        checkNotNull();
        return _getTriangleMaterialIndex(address, triangleIndex);
    }
    private static native short _getTriangleMaterialIndex(long address, int triangleIndex);

    /**
     * @param triangleIndex WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getTriangleNormal(int triangleIndex) {
        checkNotNull();
        return PxVec3.wrapPointer(_getTriangleNormal(address, triangleIndex));
    }
    private static native long _getTriangleNormal(long address, int triangleIndex);

    /**
     * @param row    WebIDL type: unsigned long
     * @param column WebIDL type: unsigned long
     * @return WebIDL type: {@link PxHeightFieldSample} [Const, Ref]
     */
    public PxHeightFieldSample getSample(int row, int column) {
        checkNotNull();
        return PxHeightFieldSample.wrapPointer(_getSample(address, row, column));
    }
    private static native long _getSample(long address, int row, int column);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getTimestamp() {
        checkNotNull();
        return _getTimestamp(address);
    }
    private static native int _getTimestamp(long address);

}
