package physx.geomutils;


public class PxSphereGeometry extends PxGeometry {

    protected PxSphereGeometry() { }

    public static PxSphereGeometry wrapPointer(long address) {
        return address != 0L ? new PxSphereGeometry(address) : null;
    }
    
    protected PxSphereGeometry(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param ir      WebIDL type: float
     * @return Stack allocated object of PxSphereGeometry
     */
    public static PxSphereGeometry createAt(long address, float ir) {
        __placement_new_PxSphereGeometry(address, ir);
        PxSphereGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param ir        WebIDL type: float
     * @return Stack allocated object of PxSphereGeometry
     */
    public static <T> PxSphereGeometry createAt(T allocator, Allocator<T> allocate, float ir) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxSphereGeometry(address, ir);
        PxSphereGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxSphereGeometry(long address, float ir);

    // Constructors

    /**
     * @param ir WebIDL type: float
     */
    public PxSphereGeometry(float ir) {
        address = _PxSphereGeometry(ir);
    }
    private static native long _PxSphereGeometry(float ir);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
