package physx.physics;

import physx.common.PxBase;
import physx.common.PxTransform;

public class PxArticulationJointBase extends PxBase {

    protected PxArticulationJointBase() { }

    public static PxArticulationJointBase wrapPointer(long address) {
        return address != 0L ? new PxArticulationJointBase(address) : null;
    }
    
    protected PxArticulationJointBase(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: {@link PxArticulationLink} [Ref]
     */
    public PxArticulationLink getParentArticulationLink() {
        checkNotNull();
        return PxArticulationLink.wrapPointer(_getParentArticulationLink(address));
    }
    private static native long _getParentArticulationLink(long address);

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setParentPose(PxTransform pose) {
        checkNotNull();
        _setParentPose(address, pose.getAddress());
    }
    private static native void _setParentPose(long address, long pose);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getParentPose() {
        checkNotNull();
        return PxTransform.wrapPointer(_getParentPose(address));
    }
    private static native long _getParentPose(long address);

    /**
     * @return WebIDL type: {@link PxArticulationLink} [Ref]
     */
    public PxArticulationLink getChildArticulationLink() {
        checkNotNull();
        return PxArticulationLink.wrapPointer(_getChildArticulationLink(address));
    }
    private static native long _getChildArticulationLink(long address);

    /**
     * @param pose WebIDL type: {@link PxTransform} [Const, Ref]
     */
    public void setChildPose(PxTransform pose) {
        checkNotNull();
        _setChildPose(address, pose.getAddress());
    }
    private static native void _setChildPose(long address, long pose);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getChildPose() {
        checkNotNull();
        return PxTransform.wrapPointer(_getChildPose(address));
    }
    private static native long _getChildPose(long address);

}
