package physx.physics;


public class PxArticulationLink extends PxRigidBody {

    protected PxArticulationLink() { }

    public static PxArticulationLink wrapPointer(long address) {
        return address != 0L ? new PxArticulationLink(address) : null;
    }
    
    protected PxArticulationLink(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: {@link PxArticulationBase} [Ref]
     */
    public PxArticulationBase getArticulation() {
        checkNotNull();
        return PxArticulationBase.wrapPointer(_getArticulation(address));
    }
    private static native long _getArticulation(long address);

    /**
     * @return WebIDL type: {@link PxArticulationJointBase}
     */
    public PxArticulationJointBase getInboundJoint() {
        checkNotNull();
        return PxArticulationJointBase.wrapPointer(_getInboundJoint(address));
    }
    private static native long _getInboundJoint(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getInboundJointDof() {
        checkNotNull();
        return _getInboundJointDof(address);
    }
    private static native int _getInboundJointDof(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbChildren() {
        checkNotNull();
        return _getNbChildren(address);
    }
    private static native int _getNbChildren(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getLinkIndex() {
        checkNotNull();
        return _getLinkIndex(address);
    }
    private static native int _getLinkIndex(long address);

}
