package physx.physics;

import physx.NativeObject;

public class PxBroadPhaseRegionInfo extends NativeObject {

    public static PxBroadPhaseRegionInfo wrapPointer(long address) {
        return address != 0L ? new PxBroadPhaseRegionInfo(address) : null;
    }
    
    protected PxBroadPhaseRegionInfo(long address) {
        super(address);
    }

    // Constructors

    public PxBroadPhaseRegionInfo() {
        address = _PxBroadPhaseRegionInfo();
    }
    private static native long _PxBroadPhaseRegionInfo();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxBroadPhaseRegion} [Value]
     */
    public PxBroadPhaseRegion getRegion() {
        checkNotNull();
        return PxBroadPhaseRegion.wrapPointer(_getRegion(address));
    }
    private static native long _getRegion(long address);

    /**
     * @param value WebIDL type: {@link PxBroadPhaseRegion} [Value]
     */
    public void setRegion(PxBroadPhaseRegion value) {
        checkNotNull();
        _setRegion(address, value.getAddress());
    }
    private static native void _setRegion(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbStaticObjects() {
        checkNotNull();
        return _getNbStaticObjects(address);
    }
    private static native int _getNbStaticObjects(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbStaticObjects(int value) {
        checkNotNull();
        _setNbStaticObjects(address, value);
    }
    private static native void _setNbStaticObjects(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbDynamicObjects() {
        checkNotNull();
        return _getNbDynamicObjects(address);
    }
    private static native int _getNbDynamicObjects(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setNbDynamicObjects(int value) {
        checkNotNull();
        _setNbDynamicObjects(address, value);
    }
    private static native void _setNbDynamicObjects(long address, int value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getActive() {
        checkNotNull();
        return _getActive(address);
    }
    private static native boolean _getActive(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setActive(boolean value) {
        checkNotNull();
        _setActive(address, value);
    }
    private static native void _setActive(long address, boolean value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getOverlap() {
        checkNotNull();
        return _getOverlap(address);
    }
    private static native boolean _getOverlap(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setOverlap(boolean value) {
        checkNotNull();
        _setOverlap(address, value);
    }
    private static native void _setOverlap(long address, boolean value);

}
