package physx.physics;

import physx.support.PxActorPtr;

public class SimpleSimulationEventCallback extends PxSimulationEventCallback {

    protected SimpleSimulationEventCallback() { }

    public static SimpleSimulationEventCallback wrapPointer(long address) {
        return address != 0L ? new SimpleSimulationEventCallback(address) : null;
    }
    
    protected SimpleSimulationEventCallback(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param constraints WebIDL type: {@link PxConstraintInfo}
     * @param count       WebIDL type: unsigned long
     */
    public void onConstraintBreak(PxConstraintInfo constraints, int count) {
        checkNotNull();
        _onConstraintBreak(address, constraints.getAddress(), count);
    }
    private static native void _onConstraintBreak(long address, long constraints, int count);

    /**
     * @param actors WebIDL type: {@link PxActorPtr}
     * @param count  WebIDL type: unsigned long
     */
    public void onWake(PxActorPtr actors, int count) {
        checkNotNull();
        _onWake(address, actors.getAddress(), count);
    }
    private static native void _onWake(long address, long actors, int count);

    /**
     * @param actors WebIDL type: {@link PxActorPtr}
     * @param count  WebIDL type: unsigned long
     */
    public void onSleep(PxActorPtr actors, int count) {
        checkNotNull();
        _onSleep(address, actors.getAddress(), count);
    }
    private static native void _onSleep(long address, long actors, int count);

    /**
     * @param pairHeader WebIDL type: {@link PxContactPairHeader} [Const, Ref]
     * @param pairs      WebIDL type: {@link PxContactPair} [Const]
     * @param nbPairs    WebIDL type: unsigned long
     */
    public void onContact(PxContactPairHeader pairHeader, PxContactPair pairs, int nbPairs) {
        checkNotNull();
        _onContact(address, pairHeader.getAddress(), pairs.getAddress(), nbPairs);
    }
    private static native void _onContact(long address, long pairHeader, long pairs, int nbPairs);

    /**
     * @param pairs WebIDL type: {@link PxTriggerPair}
     * @param count WebIDL type: unsigned long
     */
    public void onTrigger(PxTriggerPair pairs, int count) {
        checkNotNull();
        _onTrigger(address, pairs.getAddress(), count);
    }
    private static native void _onTrigger(long address, long pairs, int count);

}
