package physx.support;

import physx.NativeObject;

public class PxMaterialConstPtr extends NativeObject {

    protected PxMaterialConstPtr() { }

    public static PxMaterialConstPtr wrapPointer(long address) {
        return address != 0L ? new PxMaterialConstPtr(address) : null;
    }
    
    protected PxMaterialConstPtr(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
