package physx.support;

import physx.NativeObject;

public class SimplePvdTransport extends PxPvdTransport {

    protected SimplePvdTransport() { }

    public static SimplePvdTransport wrapPointer(long address) {
        return address != 0L ? new SimplePvdTransport(address) : null;
    }
    
    protected SimplePvdTransport(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean connect() {
        checkNotNull();
        return _connect(address);
    }
    private static native boolean _connect(long address);

    /**
     * @param inBytes  WebIDL type: any
     * @param inLength WebIDL type: unsigned long
     */
    public void send(NativeObject inBytes, int inLength) {
        checkNotNull();
        _send(address, inBytes.getAddress(), inLength);
    }
    private static native void _send(long address, long inBytes, int inLength);

}
