package physx.vehicle;


public class PxVehicleDrive extends PxVehicleWheels {

    protected PxVehicleDrive() { }

    public static PxVehicleDrive wrapPointer(long address) {
        return address != 0L ? new PxVehicleDrive(address) : null;
    }
    
    protected PxVehicleDrive(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleDriveDynData} [Value]
     */
    public PxVehicleDriveDynData getMDriveDynData() {
        checkNotNull();
        return PxVehicleDriveDynData.wrapPointer(_getMDriveDynData(address));
    }
    private static native long _getMDriveDynData(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleDriveDynData} [Value]
     */
    public void setMDriveDynData(PxVehicleDriveDynData value) {
        checkNotNull();
        _setMDriveDynData(address, value.getAddress());
    }
    private static native void _setMDriveDynData(long address, long value);

}
