package physx.vehicle;

import physx.NativeObject;

public class PxVehicleDriveDynData extends NativeObject {

    protected PxVehicleDriveDynData() { }

    public static PxVehicleDriveDynData wrapPointer(long address) {
        return address != 0L ? new PxVehicleDriveDynData(address) : null;
    }
    
    protected PxVehicleDriveDynData(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getMControlAnalogVals(int index) {
        checkNotNull();
        return _getMControlAnalogVals(address, index);
    }
    private static native float _getMControlAnalogVals(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setMControlAnalogVals(int index, float value) {
        checkNotNull();
        _setMControlAnalogVals(address, index, value);
    }
    private static native void _setMControlAnalogVals(long address, int index, float value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getMUseAutoGears() {
        checkNotNull();
        return _getMUseAutoGears(address);
    }
    private static native boolean _getMUseAutoGears(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setMUseAutoGears(boolean value) {
        checkNotNull();
        _setMUseAutoGears(address, value);
    }
    private static native void _setMUseAutoGears(long address, boolean value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getMGearUpPressed() {
        checkNotNull();
        return _getMGearUpPressed(address);
    }
    private static native boolean _getMGearUpPressed(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setMGearUpPressed(boolean value) {
        checkNotNull();
        _setMGearUpPressed(address, value);
    }
    private static native void _setMGearUpPressed(long address, boolean value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getMGearDownPressed() {
        checkNotNull();
        return _getMGearDownPressed(address);
    }
    private static native boolean _getMGearDownPressed(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setMGearDownPressed(boolean value) {
        checkNotNull();
        _setMGearDownPressed(address, value);
    }
    private static native void _setMGearDownPressed(long address, boolean value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMCurrentGear() {
        checkNotNull();
        return _getMCurrentGear(address);
    }
    private static native int _getMCurrentGear(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMCurrentGear(int value) {
        checkNotNull();
        _setMCurrentGear(address, value);
    }
    private static native void _setMCurrentGear(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMTargetGear() {
        checkNotNull();
        return _getMTargetGear(address);
    }
    private static native int _getMTargetGear(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setMTargetGear(int value) {
        checkNotNull();
        _setMTargetGear(address, value);
    }
    private static native void _setMTargetGear(long address, int value);

    /**
     * @return WebIDL type: float
     */
    public float getMEnginespeed() {
        checkNotNull();
        return _getMEnginespeed(address);
    }
    private static native float _getMEnginespeed(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMEnginespeed(float value) {
        checkNotNull();
        _setMEnginespeed(address, value);
    }
    private static native void _setMEnginespeed(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMGearSwitchTime() {
        checkNotNull();
        return _getMGearSwitchTime(address);
    }
    private static native float _getMGearSwitchTime(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMGearSwitchTime(float value) {
        checkNotNull();
        _setMGearSwitchTime(address, value);
    }
    private static native void _setMGearSwitchTime(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMAutoBoxSwitchTime() {
        checkNotNull();
        return _getMAutoBoxSwitchTime(address);
    }
    private static native float _getMAutoBoxSwitchTime(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMAutoBoxSwitchTime(float value) {
        checkNotNull();
        _setMAutoBoxSwitchTime(address, value);
    }
    private static native void _setMAutoBoxSwitchTime(long address, float value);

    // Functions

    public void setToRestState() {
        checkNotNull();
        _setToRestState(address);
    }
    private static native void _setToRestState(long address);

    /**
     * @param type      WebIDL type: unsigned long
     * @param analogVal WebIDL type: float
     */
    public void setAnalogInput(int type, float analogVal) {
        checkNotNull();
        _setAnalogInput(address, type, analogVal);
    }
    private static native void _setAnalogInput(long address, int type, float analogVal);

    /**
     * @param type WebIDL type: unsigned long
     * @return WebIDL type: float
     */
    public float getAnalogInput(int type) {
        checkNotNull();
        return _getAnalogInput(address, type);
    }
    private static native float _getAnalogInput(long address, int type);

    /**
     * @param digitalVal WebIDL type: boolean
     */
    public void setGearUp(boolean digitalVal) {
        checkNotNull();
        _setGearUp(address, digitalVal);
    }
    private static native void _setGearUp(long address, boolean digitalVal);

    /**
     * @param digitalVal WebIDL type: boolean
     */
    public void setGearDown(boolean digitalVal) {
        checkNotNull();
        _setGearDown(address, digitalVal);
    }
    private static native void _setGearDown(long address, boolean digitalVal);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getGearUp() {
        checkNotNull();
        return _getGearUp(address);
    }
    private static native boolean _getGearUp(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getGearDown() {
        checkNotNull();
        return _getGearDown(address);
    }
    private static native boolean _getGearDown(long address);

    /**
     * @param useAutoGears WebIDL type: boolean
     */
    public void setUseAutoGears(boolean useAutoGears) {
        checkNotNull();
        _setUseAutoGears(address, useAutoGears);
    }
    private static native void _setUseAutoGears(long address, boolean useAutoGears);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getUseAutoGears() {
        checkNotNull();
        return _getUseAutoGears(address);
    }
    private static native boolean _getUseAutoGears(long address);

    public void toggleAutoGears() {
        checkNotNull();
        _toggleAutoGears(address);
    }
    private static native void _toggleAutoGears(long address);

    /**
     * @param currentGear WebIDL type: unsigned long
     */
    public void setCurrentGear(int currentGear) {
        checkNotNull();
        _setCurrentGear(address, currentGear);
    }
    private static native void _setCurrentGear(long address, int currentGear);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getCurrentGear() {
        checkNotNull();
        return _getCurrentGear(address);
    }
    private static native int _getCurrentGear(long address);

    /**
     * @param targetGear WebIDL type: unsigned long
     */
    public void setTargetGear(int targetGear) {
        checkNotNull();
        _setTargetGear(address, targetGear);
    }
    private static native void _setTargetGear(long address, int targetGear);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getTargetGear() {
        checkNotNull();
        return _getTargetGear(address);
    }
    private static native int _getTargetGear(long address);

    /**
     * @param targetGear WebIDL type: unsigned long
     */
    public void startGearChange(int targetGear) {
        checkNotNull();
        _startGearChange(address, targetGear);
    }
    private static native void _startGearChange(long address, int targetGear);

    /**
     * @param targetGear WebIDL type: unsigned long
     */
    public void forceGearChange(int targetGear) {
        checkNotNull();
        _forceGearChange(address, targetGear);
    }
    private static native void _forceGearChange(long address, int targetGear);

    /**
     * @param speed WebIDL type: float
     */
    public void setEngineRotationSpeed(float speed) {
        checkNotNull();
        _setEngineRotationSpeed(address, speed);
    }
    private static native void _setEngineRotationSpeed(long address, float speed);

    /**
     * @return WebIDL type: float
     */
    public float getEngineRotationSpeed() {
        checkNotNull();
        return _getEngineRotationSpeed(address);
    }
    private static native float _getEngineRotationSpeed(long address);

    /**
     * @return WebIDL type: float
     */
    public float getGearSwitchTime() {
        checkNotNull();
        return _getGearSwitchTime(address);
    }
    private static native float _getGearSwitchTime(long address);

    /**
     * @return WebIDL type: float
     */
    public float getAutoBoxSwitchTime() {
        checkNotNull();
        return _getAutoBoxSwitchTime(address);
    }
    private static native float _getAutoBoxSwitchTime(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbAnalogInput() {
        checkNotNull();
        return _getNbAnalogInput(address);
    }
    private static native int _getNbAnalogInput(long address);

    /**
     * @param gearChange WebIDL type: unsigned long
     */
    public void setGearChange(int gearChange) {
        checkNotNull();
        _setGearChange(address, gearChange);
    }
    private static native void _setGearChange(long address, int gearChange);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getGearChange() {
        checkNotNull();
        return _getGearChange(address);
    }
    private static native int _getGearChange(long address);

    /**
     * @param switchTime WebIDL type: float
     */
    public void setGearSwitchTime(float switchTime) {
        checkNotNull();
        _setGearSwitchTime(address, switchTime);
    }
    private static native void _setGearSwitchTime(long address, float switchTime);

    /**
     * @param autoBoxSwitchTime WebIDL type: float
     */
    public void setAutoBoxSwitchTime(float autoBoxSwitchTime) {
        checkNotNull();
        _setAutoBoxSwitchTime(address, autoBoxSwitchTime);
    }
    private static native void _setAutoBoxSwitchTime(long address, float autoBoxSwitchTime);

}
