package physx.vehicle;

import physx.NativeObject;

public class PxVehicleSuspensionData extends NativeObject {

    public static PxVehicleSuspensionData wrapPointer(long address) {
        return address != 0L ? new PxVehicleSuspensionData(address) : null;
    }
    
    protected PxVehicleSuspensionData(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleSuspensionData
     */
    public static PxVehicleSuspensionData createAt(long address) {
        __placement_new_PxVehicleSuspensionData(address);
        PxVehicleSuspensionData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleSuspensionData
     */
    public static <T> PxVehicleSuspensionData createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleSuspensionData(address);
        PxVehicleSuspensionData createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleSuspensionData(long address);

    // Constructors

    public PxVehicleSuspensionData() {
        address = _PxVehicleSuspensionData();
    }
    private static native long _PxVehicleSuspensionData();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getMSpringStrength() {
        checkNotNull();
        return _getMSpringStrength(address);
    }
    private static native float _getMSpringStrength(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMSpringStrength(float value) {
        checkNotNull();
        _setMSpringStrength(address, value);
    }
    private static native void _setMSpringStrength(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMSpringDamperRate() {
        checkNotNull();
        return _getMSpringDamperRate(address);
    }
    private static native float _getMSpringDamperRate(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMSpringDamperRate(float value) {
        checkNotNull();
        _setMSpringDamperRate(address, value);
    }
    private static native void _setMSpringDamperRate(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMaxCompression() {
        checkNotNull();
        return _getMMaxCompression(address);
    }
    private static native float _getMMaxCompression(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMaxCompression(float value) {
        checkNotNull();
        _setMMaxCompression(address, value);
    }
    private static native void _setMMaxCompression(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMMaxDroop() {
        checkNotNull();
        return _getMMaxDroop(address);
    }
    private static native float _getMMaxDroop(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMMaxDroop(float value) {
        checkNotNull();
        _setMMaxDroop(address, value);
    }
    private static native void _setMMaxDroop(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMSprungMass() {
        checkNotNull();
        return _getMSprungMass(address);
    }
    private static native float _getMSprungMass(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMSprungMass(float value) {
        checkNotNull();
        _setMSprungMass(address, value);
    }
    private static native void _setMSprungMass(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMCamberAtRest() {
        checkNotNull();
        return _getMCamberAtRest(address);
    }
    private static native float _getMCamberAtRest(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMCamberAtRest(float value) {
        checkNotNull();
        _setMCamberAtRest(address, value);
    }
    private static native void _setMCamberAtRest(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMCamberAtMaxCompression() {
        checkNotNull();
        return _getMCamberAtMaxCompression(address);
    }
    private static native float _getMCamberAtMaxCompression(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMCamberAtMaxCompression(float value) {
        checkNotNull();
        _setMCamberAtMaxCompression(address, value);
    }
    private static native void _setMCamberAtMaxCompression(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getMCamberAtMaxDroop() {
        checkNotNull();
        return _getMCamberAtMaxDroop(address);
    }
    private static native float _getMCamberAtMaxDroop(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMCamberAtMaxDroop(float value) {
        checkNotNull();
        _setMCamberAtMaxDroop(address, value);
    }
    private static native void _setMCamberAtMaxDroop(long address, float value);

    // Functions

    /**
     * @param newSprungMass WebIDL type: float
     */
    public void setMassAndPreserveNaturalFrequency(float newSprungMass) {
        checkNotNull();
        _setMassAndPreserveNaturalFrequency(address, newSprungMass);
    }
    private static native void _setMassAndPreserveNaturalFrequency(long address, float newSprungMass);

}
