package physx.character;


public class PxBoxControllerDesc extends PxControllerDesc {

    public static PxBoxControllerDesc wrapPointer(long address) {
        return address != 0L ? new PxBoxControllerDesc(address) : null;
    }
    
    protected PxBoxControllerDesc(long address) {
        super(address);
    }

    // Constructors

    public PxBoxControllerDesc() {
        address = _PxBoxControllerDesc();
    }
    private static native long _PxBoxControllerDesc();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getHalfHeight() {
        checkNotNull();
        return _getHalfHeight(address);
    }
    private static native float _getHalfHeight(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setHalfHeight(float value) {
        checkNotNull();
        _setHalfHeight(address, value);
    }
    private static native void _setHalfHeight(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getHalfSideExtent() {
        checkNotNull();
        return _getHalfSideExtent(address);
    }
    private static native float _getHalfSideExtent(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setHalfSideExtent(float value) {
        checkNotNull();
        _setHalfSideExtent(address, value);
    }
    private static native void _setHalfSideExtent(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getHalfForwardExtent() {
        checkNotNull();
        return _getHalfForwardExtent(address);
    }
    private static native float _getHalfForwardExtent(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setHalfForwardExtent(float value) {
        checkNotNull();
        _setHalfForwardExtent(address, value);
    }
    private static native void _setHalfForwardExtent(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
