package physx.extensions;

import physx.NativeObject;

public class PxD6JointDriveFlags extends NativeObject {

    protected PxD6JointDriveFlags() { }

    public static PxD6JointDriveFlags wrapPointer(long address) {
        return address != 0L ? new PxD6JointDriveFlags(address) : null;
    }
    
    protected PxD6JointDriveFlags(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param flags WebIDL type: unsigned long
     */
    public PxD6JointDriveFlags(int flags) {
        address = _PxD6JointDriveFlags(flags);
    }
    private static native long _PxD6JointDriveFlags(int flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxD6JointDriveFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(int flag) {
        checkNotNull();
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxD6JointDriveFlagEnum} [enum]
     */
    public void set(int flag) {
        checkNotNull();
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxD6JointDriveFlagEnum} [enum]
     */
    public void clear(int flag) {
        checkNotNull();
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
