package physx.extensions;


public class PxJointLinearLimitPair extends PxJointLimitParameters {

    protected PxJointLinearLimitPair() { }

    public static PxJointLinearLimitPair wrapPointer(long address) {
        return address != 0L ? new PxJointLinearLimitPair(address) : null;
    }
    
    protected PxJointLinearLimitPair(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param lowerLimit WebIDL type: float
     * @param upperLimit WebIDL type: float
     * @param spring     WebIDL type: {@link PxSpring} [Const, Ref]
     */
    public PxJointLinearLimitPair(float lowerLimit, float upperLimit, PxSpring spring) {
        address = _PxJointLinearLimitPair(lowerLimit, upperLimit, spring.getAddress());
    }
    private static native long _PxJointLinearLimitPair(float lowerLimit, float upperLimit, long spring);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getUpper() {
        checkNotNull();
        return _getUpper(address);
    }
    private static native float _getUpper(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setUpper(float value) {
        checkNotNull();
        _setUpper(address, value);
    }
    private static native void _setUpper(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getLower() {
        checkNotNull();
        return _getLower(address);
    }
    private static native float _getLower(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setLower(float value) {
        checkNotNull();
        _setLower(address, value);
    }
    private static native void _setLower(long address, float value);

}
