package physx.physics;

import physx.NativeObject;

public class PxQueryFlags extends NativeObject {

    protected PxQueryFlags() { }

    public static PxQueryFlags wrapPointer(long address) {
        return address != 0L ? new PxQueryFlags(address) : null;
    }
    
    protected PxQueryFlags(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param flags WebIDL type: unsigned short
     */
    public PxQueryFlags(short flags) {
        address = _PxQueryFlags(flags);
    }
    private static native long _PxQueryFlags(short flags);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param flag WebIDL type: {@link PxQueryFlagEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean isSet(int flag) {
        checkNotNull();
        return _isSet(address, flag);
    }
    private static native boolean _isSet(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxQueryFlagEnum} [enum]
     */
    public void set(int flag) {
        checkNotNull();
        _set(address, flag);
    }
    private static native void _set(long address, int flag);

    /**
     * @param flag WebIDL type: {@link PxQueryFlagEnum} [enum]
     */
    public void clear(int flag) {
        checkNotNull();
        _clear(address, flag);
    }
    private static native void _clear(long address, int flag);

}
