package physx.physics;

import physx.NativeObject;

public class PxSweepCallback extends NativeObject {

    protected PxSweepCallback() { }

    public static PxSweepCallback wrapPointer(long address) {
        return address != 0L ? new PxSweepCallback(address) : null;
    }
    
    protected PxSweepCallback(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean hasAnyHits() {
        checkNotNull();
        return _hasAnyHits(address);
    }
    private static native boolean _hasAnyHits(long address);

}
