package physx.support;

import physx.NativeObject;
import physx.vehicle.PxVehicleDrivableSurfaceType;

public class Vector_PxVehicleDrivableSurfaceType extends NativeObject {

    public static Vector_PxVehicleDrivableSurfaceType wrapPointer(long address) {
        return address != 0L ? new Vector_PxVehicleDrivableSurfaceType(address) : null;
    }
    
    protected Vector_PxVehicleDrivableSurfaceType(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxVehicleDrivableSurfaceType() {
        address = _Vector_PxVehicleDrivableSurfaceType();
    }
    private static native long _Vector_PxVehicleDrivableSurfaceType();

    /**
     * @param size WebIDL type: unsigned long
     */
    public Vector_PxVehicleDrivableSurfaceType(int size) {
        address = _Vector_PxVehicleDrivableSurfaceType(size);
    }
    private static native long _Vector_PxVehicleDrivableSurfaceType(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVehicleDrivableSurfaceType} [Ref]
     */
    public PxVehicleDrivableSurfaceType at(int index) {
        checkNotNull();
        return PxVehicleDrivableSurfaceType.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return WebIDL type: {@link PxVehicleDrivableSurfaceType}
     */
    public PxVehicleDrivableSurfaceType data() {
        checkNotNull();
        return PxVehicleDrivableSurfaceType.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleDrivableSurfaceType} [Ref]
     */
    public void push_back(PxVehicleDrivableSurfaceType value) {
        checkNotNull();
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

}
