package physx.support;

import physx.NativeObject;
import physx.vehicle.PxVehicleWheels;

public class Vector_PxVehicleWheels extends NativeObject {

    public static Vector_PxVehicleWheels wrapPointer(long address) {
        return address != 0L ? new Vector_PxVehicleWheels(address) : null;
    }
    
    protected Vector_PxVehicleWheels(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxVehicleWheels() {
        address = _Vector_PxVehicleWheels();
    }
    private static native long _Vector_PxVehicleWheels();

    /**
     * @param size WebIDL type: unsigned long
     */
    public Vector_PxVehicleWheels(int size) {
        address = _Vector_PxVehicleWheels(size);
    }
    private static native long _Vector_PxVehicleWheels(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVehicleWheels}
     */
    public PxVehicleWheels at(int index) {
        checkNotNull();
        return PxVehicleWheels.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return WebIDL type: {@link PxVehicleWheelsPtr}
     */
    public PxVehicleWheelsPtr data() {
        checkNotNull();
        return PxVehicleWheelsPtr.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleWheels}
     */
    public void push_back(PxVehicleWheels value) {
        checkNotNull();
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

}
