package physx.vehicle;

import physx.NativeObject;
import physx.support.PxMaterialConstPtr;

public class PxVehicleDrivableSurfaceToTireFrictionPairs extends NativeObject {

    protected PxVehicleDrivableSurfaceToTireFrictionPairs() { }

    public static PxVehicleDrivableSurfaceToTireFrictionPairs wrapPointer(long address) {
        return address != 0L ? new PxVehicleDrivableSurfaceToTireFrictionPairs(address) : null;
    }
    
    protected PxVehicleDrivableSurfaceToTireFrictionPairs(long address) {
        super(address);
    }

    // Functions

    /**
     * @param maxNbTireTypes    WebIDL type: unsigned long
     * @param maxNbSurfaceTypes WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVehicleDrivableSurfaceToTireFrictionPairs}
     */
    public static PxVehicleDrivableSurfaceToTireFrictionPairs allocate(int maxNbTireTypes, int maxNbSurfaceTypes) {
        return PxVehicleDrivableSurfaceToTireFrictionPairs.wrapPointer(_allocate(maxNbTireTypes, maxNbSurfaceTypes));
    }
    private static native long _allocate(int maxNbTireTypes, int maxNbSurfaceTypes);

    /**
     * @param nbTireTypes              WebIDL type: unsigned long
     * @param nbSurfaceTypes           WebIDL type: unsigned long
     * @param drivableSurfaceMaterials WebIDL type: {@link PxMaterialConstPtr}
     * @param drivableSurfaceTypes     WebIDL type: {@link PxVehicleDrivableSurfaceType} [Const]
     */
    public void setup(int nbTireTypes, int nbSurfaceTypes, PxMaterialConstPtr drivableSurfaceMaterials, PxVehicleDrivableSurfaceType drivableSurfaceTypes) {
        checkNotNull();
        _setup(address, nbTireTypes, nbSurfaceTypes, drivableSurfaceMaterials.getAddress(), drivableSurfaceTypes.getAddress());
    }
    private static native void _setup(long address, int nbTireTypes, int nbSurfaceTypes, long drivableSurfaceMaterials, long drivableSurfaceTypes);

    public void release() {
        checkNotNull();
        _release(address);
    }
    private static native void _release(long address);

    /**
     * @param surfaceType WebIDL type: unsigned long
     * @param tireType    WebIDL type: unsigned long
     * @param value       WebIDL type: float
     */
    public void setTypePairFriction(int surfaceType, int tireType, float value) {
        checkNotNull();
        _setTypePairFriction(address, surfaceType, tireType, value);
    }
    private static native void _setTypePairFriction(long address, int surfaceType, int tireType, float value);

    /**
     * @param surfaceType WebIDL type: unsigned long
     * @param tireType    WebIDL type: unsigned long
     * @return WebIDL type: float
     */
    public float getTypePairFriction(int surfaceType, int tireType) {
        checkNotNull();
        return _getTypePairFriction(address, surfaceType, tireType);
    }
    private static native float _getTypePairFriction(long address, int surfaceType, int tireType);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbSurfaceTypes() {
        checkNotNull();
        return _getMaxNbSurfaceTypes(address);
    }
    private static native int _getMaxNbSurfaceTypes(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getMaxNbTireTypes() {
        checkNotNull();
        return _getMaxNbTireTypes(address);
    }
    private static native int _getMaxNbTireTypes(long address);

}
