package physx.character;


public class PxCapsuleController extends PxController {

    protected PxCapsuleController() { }

    public static PxCapsuleController wrapPointer(long address) {
        return address != 0L ? new PxCapsuleController(address) : null;
    }
    
    protected PxCapsuleController(long address) {
        super(address);
    }

    // Functions

    /**
     * @return WebIDL type: float
     */
    public float getRadius() {
        checkNotNull();
        return _getRadius(address);
    }
    private static native float _getRadius(long address);

    /**
     * @param radius WebIDL type: float
     */
    public void setRadius(float radius) {
        checkNotNull();
        _setRadius(address, radius);
    }
    private static native void _setRadius(long address, float radius);

    /**
     * @return WebIDL type: float
     */
    public float getHeight() {
        checkNotNull();
        return _getHeight(address);
    }
    private static native float _getHeight(long address);

    /**
     * @param height WebIDL type: float
     */
    public void setHeight(float height) {
        checkNotNull();
        _setHeight(address, height);
    }
    private static native void _setHeight(long address, float height);

    /**
     * @return WebIDL type: {@link PxCapsuleClimbingModeEnum} [enum]
     */
    public int getClimbingMode() {
        checkNotNull();
        return _getClimbingMode(address);
    }
    private static native int _getClimbingMode(long address);

    /**
     * @param mode WebIDL type: {@link PxCapsuleClimbingModeEnum} [enum]
     * @return WebIDL type: boolean
     */
    public boolean setClimbingMode(int mode) {
        checkNotNull();
        return _setClimbingMode(address, mode);
    }
    private static native boolean _setClimbingMode(long address, int mode);

}
