package physx.character;

import physx.NativeObject;
import physx.common.PxVec3;
import physx.physics.PxRigidActor;
import physx.physics.PxShape;

public class PxControllerState extends NativeObject {

    public static PxControllerState wrapPointer(long address) {
        return address != 0L ? new PxControllerState(address) : null;
    }
    
    protected PxControllerState(long address) {
        super(address);
    }

    // Constructors

    public PxControllerState() {
        address = _PxControllerState();
    }
    private static native long _PxControllerState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getDeltaXP() {
        checkNotNull();
        return PxVec3.wrapPointer(_getDeltaXP(address));
    }
    private static native long _getDeltaXP(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setDeltaXP(PxVec3 value) {
        checkNotNull();
        _setDeltaXP(address, value.getAddress());
    }
    private static native void _setDeltaXP(long address, long value);

    /**
     * @return WebIDL type: {@link PxShape}
     */
    public PxShape getTouchedShape() {
        checkNotNull();
        return PxShape.wrapPointer(_getTouchedShape(address));
    }
    private static native long _getTouchedShape(long address);

    /**
     * @param value WebIDL type: {@link PxShape}
     */
    public void setTouchedShape(PxShape value) {
        checkNotNull();
        _setTouchedShape(address, value.getAddress());
    }
    private static native void _setTouchedShape(long address, long value);

    /**
     * @return WebIDL type: {@link PxRigidActor}
     */
    public PxRigidActor getTouchedActor() {
        checkNotNull();
        return PxRigidActor.wrapPointer(_getTouchedActor(address));
    }
    private static native long _getTouchedActor(long address);

    /**
     * @param value WebIDL type: {@link PxRigidActor}
     */
    public void setTouchedActor(PxRigidActor value) {
        checkNotNull();
        _setTouchedActor(address, value.getAddress());
    }
    private static native void _setTouchedActor(long address, long value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getTouchedObstacleHandle() {
        checkNotNull();
        return _getTouchedObstacleHandle(address);
    }
    private static native int _getTouchedObstacleHandle(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setTouchedObstacleHandle(int value) {
        checkNotNull();
        _setTouchedObstacleHandle(address, value);
    }
    private static native void _setTouchedObstacleHandle(long address, int value);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getCollisionFlags() {
        checkNotNull();
        return _getCollisionFlags(address);
    }
    private static native int _getCollisionFlags(long address);

    /**
     * @param value WebIDL type: unsigned long
     */
    public void setCollisionFlags(int value) {
        checkNotNull();
        _setCollisionFlags(address, value);
    }
    private static native void _setCollisionFlags(long address, int value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getStandOnAnotherCCT() {
        checkNotNull();
        return _getStandOnAnotherCCT(address);
    }
    private static native boolean _getStandOnAnotherCCT(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setStandOnAnotherCCT(boolean value) {
        checkNotNull();
        _setStandOnAnotherCCT(address, value);
    }
    private static native void _setStandOnAnotherCCT(long address, boolean value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getStandOnObstacle() {
        checkNotNull();
        return _getStandOnObstacle(address);
    }
    private static native boolean _getStandOnObstacle(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setStandOnObstacle(boolean value) {
        checkNotNull();
        _setStandOnObstacle(address, value);
    }
    private static native void _setStandOnObstacle(long address, boolean value);

    /**
     * @return WebIDL type: boolean
     */
    public boolean getIsMovingUp() {
        checkNotNull();
        return _getIsMovingUp(address);
    }
    private static native boolean _getIsMovingUp(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setIsMovingUp(boolean value) {
        checkNotNull();
        _setIsMovingUp(address, value);
    }
    private static native void _setIsMovingUp(long address, boolean value);

}
