package physx.common;

import physx.NativeObject;

public class PxTolerancesScale extends NativeObject {

    public static PxTolerancesScale wrapPointer(long address) {
        return address != 0L ? new PxTolerancesScale(address) : null;
    }
    
    protected PxTolerancesScale(long address) {
        super(address);
    }

    // Constructors

    public PxTolerancesScale() {
        address = _PxTolerancesScale();
    }
    private static native long _PxTolerancesScale();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
