package physx.vehicle;

import physx.physics.PxPhysics;
import physx.physics.PxRigidDynamic;

public class PxVehicleDriveNW extends PxVehicleDrive {

    protected PxVehicleDriveNW() { }

    public static PxVehicleDriveNW wrapPointer(long address) {
        return address != 0L ? new PxVehicleDriveNW(address) : null;
    }
    
    protected PxVehicleDriveNW(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleDriveSimDataNW} [Value]
     */
    public PxVehicleDriveSimDataNW getMDriveSimData() {
        checkNotNull();
        return PxVehicleDriveSimDataNW.wrapPointer(_getMDriveSimData(address));
    }
    private static native long _getMDriveSimData(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleDriveSimDataNW} [Value]
     */
    public void setMDriveSimData(PxVehicleDriveSimDataNW value) {
        checkNotNull();
        _setMDriveSimData(address, value.getAddress());
    }
    private static native void _setMDriveSimData(long address, long value);

    // Functions

    /**
     * @param nbWheels WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVehicleDriveNW}
     */
    public static PxVehicleDriveNW allocate(int nbWheels) {
        return PxVehicleDriveNW.wrapPointer(_allocate(nbWheels));
    }
    private static native long _allocate(int nbWheels);

    public void free() {
        checkNotNull();
        _free(address);
    }
    private static native void _free(long address);

    /**
     * @param physics    WebIDL type: {@link PxPhysics}
     * @param vehActor   WebIDL type: {@link PxRigidDynamic}
     * @param wheelsData WebIDL type: {@link PxVehicleWheelsSimData} [Const, Ref]
     * @param driveData  WebIDL type: {@link PxVehicleDriveSimDataNW} [Const, Ref]
     * @param nbWheels   WebIDL type: unsigned long
     */
    public void setup(PxPhysics physics, PxRigidDynamic vehActor, PxVehicleWheelsSimData wheelsData, PxVehicleDriveSimDataNW driveData, int nbWheels) {
        checkNotNull();
        _setup(address, physics.getAddress(), vehActor.getAddress(), wheelsData.getAddress(), driveData.getAddress(), nbWheels);
    }
    private static native void _setup(long address, long physics, long vehActor, long wheelsData, long driveData, int nbWheels);

    public void setToRestState() {
        checkNotNull();
        _setToRestState(address);
    }
    private static native void _setToRestState(long address);

}
