/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.NativeObject;
import physx.extensions.BatchVehicleUpdateDesc;
import physx.vehicle.PxVehicleWheels;
import physx.vehicle.PxWheelQueryResult;

public class BatchVehicleUpdate
extends NativeObject {
    protected BatchVehicleUpdate() {
    }

    public static BatchVehicleUpdate wrapPointer(long address) {
        return address != 0L ? new BatchVehicleUpdate(address) : null;
    }

    protected BatchVehicleUpdate(long address) {
        super(address);
    }

    public BatchVehicleUpdate(BatchVehicleUpdateDesc desc) {
        this.address = BatchVehicleUpdate._BatchVehicleUpdate(desc.getAddress());
    }

    private static native long _BatchVehicleUpdate(long var0);

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        BatchVehicleUpdate._delete_native_instance(this.address);
        this.address = 0L;
    }

    private static native long _delete_native_instance(long var0);

    public void addVehicle(PxVehicleWheels vehicle) {
        this.checkNotNull();
        BatchVehicleUpdate._addVehicle(this.address, vehicle.getAddress());
    }

    private static native void _addVehicle(long var0, long var2);

    public void removeVehicle(PxVehicleWheels vehicle) {
        this.checkNotNull();
        BatchVehicleUpdate._removeVehicle(this.address, vehicle.getAddress());
    }

    private static native void _removeVehicle(long var0, long var2);

    public void removeAllVehicles() {
        this.checkNotNull();
        BatchVehicleUpdate._removeAllVehicles(this.address);
    }

    private static native void _removeAllVehicles(long var0);

    public int indexOf(PxVehicleWheels vehicle) {
        this.checkNotNull();
        return BatchVehicleUpdate._indexOf(this.address, vehicle.getAddress());
    }

    private static native int _indexOf(long var0, long var2);

    public void batchUpdate(float timestep) {
        this.checkNotNull();
        BatchVehicleUpdate._batchUpdate(this.address, timestep);
    }

    private static native void _batchUpdate(long var0, float var2);

    public PxWheelQueryResult getWheelQueryResult(int vehicleId, int wheelId) {
        this.checkNotNull();
        return PxWheelQueryResult.wrapPointer(BatchVehicleUpdate._getWheelQueryResult(this.address, vehicleId, wheelId));
    }

    private static native long _getWheelQueryResult(long var0, int var2, int var3);
}

