/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.extensions.PxJoint;
import physx.extensions.PxJointAngularLimitPair;
import physx.extensions.PxRevoluteJointFlags;

public class PxRevoluteJoint
extends PxJoint {
    protected PxRevoluteJoint() {
    }

    public static PxRevoluteJoint wrapPointer(long address) {
        return address != 0L ? new PxRevoluteJoint(address) : null;
    }

    protected PxRevoluteJoint(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        PxRevoluteJoint._delete_native_instance(this.address);
        this.address = 0L;
    }

    private static native long _delete_native_instance(long var0);

    public float getAngle() {
        this.checkNotNull();
        return PxRevoluteJoint._getAngle(this.address);
    }

    private static native float _getAngle(long var0);

    public float getVelocity() {
        this.checkNotNull();
        return PxRevoluteJoint._getVelocity(this.address);
    }

    private static native float _getVelocity(long var0);

    public void setLimit(PxJointAngularLimitPair limits) {
        this.checkNotNull();
        PxRevoluteJoint._setLimit(this.address, limits.getAddress());
    }

    private static native void _setLimit(long var0, long var2);

    public void setDriveVelocity(float velocity) {
        this.checkNotNull();
        PxRevoluteJoint._setDriveVelocity(this.address, velocity);
    }

    private static native void _setDriveVelocity(long var0, float var2);

    public void setDriveVelocity(float velocity, boolean autowake) {
        this.checkNotNull();
        PxRevoluteJoint._setDriveVelocity(this.address, velocity, autowake);
    }

    private static native void _setDriveVelocity(long var0, float var2, boolean var3);

    public float getDriveVelocity() {
        this.checkNotNull();
        return PxRevoluteJoint._getDriveVelocity(this.address);
    }

    private static native float _getDriveVelocity(long var0);

    public void setDriveForceLimit(float limit) {
        this.checkNotNull();
        PxRevoluteJoint._setDriveForceLimit(this.address, limit);
    }

    private static native void _setDriveForceLimit(long var0, float var2);

    public float getDriveForceLimit() {
        this.checkNotNull();
        return PxRevoluteJoint._getDriveForceLimit(this.address);
    }

    private static native float _getDriveForceLimit(long var0);

    public void setDriveGearRatio(float ratio) {
        this.checkNotNull();
        PxRevoluteJoint._setDriveGearRatio(this.address, ratio);
    }

    private static native void _setDriveGearRatio(long var0, float var2);

    public float getDriveGearRatio() {
        this.checkNotNull();
        return PxRevoluteJoint._getDriveGearRatio(this.address);
    }

    private static native float _getDriveGearRatio(long var0);

    public void setRevoluteJointFlags(PxRevoluteJointFlags flags) {
        this.checkNotNull();
        PxRevoluteJoint._setRevoluteJointFlags(this.address, flags.getAddress());
    }

    private static native void _setRevoluteJointFlags(long var0, long var2);

    public void setRevoluteJointFlag(int flag, boolean value) {
        this.checkNotNull();
        PxRevoluteJoint._setRevoluteJointFlag(this.address, flag, value);
    }

    private static native void _setRevoluteJointFlag(long var0, int var2, boolean var3);

    public PxRevoluteJointFlags getRevoluteJointFlags() {
        this.checkNotNull();
        return PxRevoluteJointFlags.wrapPointer(PxRevoluteJoint._getRevoluteJointFlags(this.address));
    }

    private static native long _getRevoluteJointFlags(long var0);

    public void setProjectionLinearTolerance(float tolerance) {
        this.checkNotNull();
        PxRevoluteJoint._setProjectionLinearTolerance(this.address, tolerance);
    }

    private static native void _setProjectionLinearTolerance(long var0, float var2);

    public float getProjectionLinearTolerance() {
        this.checkNotNull();
        return PxRevoluteJoint._getProjectionLinearTolerance(this.address);
    }

    private static native float _getProjectionLinearTolerance(long var0);

    public void setProjectionAngularTolerance(float tolerance) {
        this.checkNotNull();
        PxRevoluteJoint._setProjectionAngularTolerance(this.address, tolerance);
    }

    private static native void _setProjectionAngularTolerance(long var0, float var2);

    public float getProjectionAngularTolerance() {
        this.checkNotNull();
        return PxRevoluteJoint._getProjectionAngularTolerance(this.address);
    }

    private static native float _getProjectionAngularTolerance(long var0);
}

