package physx.extensions;


public class PxSphericalJoint extends PxJoint {

    protected PxSphericalJoint() { }

    public static PxSphericalJoint wrapPointer(long address) {
        return address != 0L ? new PxSphericalJoint(address) : null;
    }
    
    protected PxSphericalJoint(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param limitCone WebIDL type: {@link PxJointLimitCone} [Const, Ref]
     */
    public void setLimitCone(PxJointLimitCone limitCone) {
        checkNotNull();
        _setLimitCone(address, limitCone.getAddress());
    }
    private static native void _setLimitCone(long address, long limitCone);

    /**
     * @return WebIDL type: float
     */
    public float getSwingYAngle() {
        checkNotNull();
        return _getSwingYAngle(address);
    }
    private static native float _getSwingYAngle(long address);

    /**
     * @return WebIDL type: float
     */
    public float getSwingZAngle() {
        checkNotNull();
        return _getSwingZAngle(address);
    }
    private static native float _getSwingZAngle(long address);

    /**
     * @param flags WebIDL type: {@link PxSphericalJointFlags} [Ref]
     */
    public void setSphericalJointFlags(PxSphericalJointFlags flags) {
        checkNotNull();
        _setSphericalJointFlags(address, flags.getAddress());
    }
    private static native void _setSphericalJointFlags(long address, long flags);

    /**
     * @param flag  WebIDL type: {@link PxSphericalJointFlagEnum} [enum]
     * @param value WebIDL type: boolean
     */
    public void setSphericalJointFlag(int flag, boolean value) {
        checkNotNull();
        _setSphericalJointFlag(address, flag, value);
    }
    private static native void _setSphericalJointFlag(long address, int flag, boolean value);

    /**
     * @return WebIDL type: {@link PxSphericalJointFlags} [Value]
     */
    public PxSphericalJointFlags getSphericalJointFlags() {
        checkNotNull();
        return PxSphericalJointFlags.wrapPointer(_getSphericalJointFlags(address));
    }
    private static native long _getSphericalJointFlags(long address);

    /**
     * @param tolerance WebIDL type: float
     */
    public void setProjectionLinearTolerance(float tolerance) {
        checkNotNull();
        _setProjectionLinearTolerance(address, tolerance);
    }
    private static native void _setProjectionLinearTolerance(long address, float tolerance);

    /**
     * @return WebIDL type: float
     */
    public float getProjectionLinearTolerance() {
        checkNotNull();
        return _getProjectionLinearTolerance(address);
    }
    private static native float _getProjectionLinearTolerance(long address);

}
