package physx.support;

import physx.NativeObject;
import physx.common.PxVec3;
import physx.physics.PxArticulationJoint;
import physx.physics.PxArticulationJointBase;
import physx.physics.PxContactPair;
import physx.physics.PxTriggerPair;

public class TypeHelpers extends NativeObject {

    protected TypeHelpers() { }

    public static TypeHelpers wrapPointer(long address) {
        return address != 0L ? new TypeHelpers(address) : null;
    }
    
    protected TypeHelpers(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param base  WebIDL type: {@link PxU8ConstPtr} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: octet
     */
    public static byte getU8At(PxU8ConstPtr base, int index) {
        return _getU8At(base.getAddress(), index);
    }
    private static native byte _getU8At(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxU16ConstPtr} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: unsigned short
     */
    public static short getU16At(PxU16ConstPtr base, int index) {
        return _getU16At(base.getAddress(), index);
    }
    private static native short _getU16At(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxU32ConstPtr} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: unsigned long
     */
    public static int getU32At(PxU32ConstPtr base, int index) {
        return _getU32At(base.getAddress(), index);
    }
    private static native int _getU32At(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxRealPtr} [Ref]
     * @param index WebIDL type: long
     * @return WebIDL type: float
     */
    public static float getRealAt(PxRealPtr base, int index) {
        return _getRealAt(base.getAddress(), index);
    }
    private static native float _getRealAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxContactPair}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxContactPair}
     */
    public static PxContactPair getContactPairAt(PxContactPair base, int index) {
        return PxContactPair.wrapPointer(_getContactPairAt(base.getAddress(), index));
    }
    private static native long _getContactPairAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxTriggerPair}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxTriggerPair}
     */
    public static PxTriggerPair getTriggerPairAt(PxTriggerPair base, int index) {
        return PxTriggerPair.wrapPointer(_getTriggerPairAt(base.getAddress(), index));
    }
    private static native long _getTriggerPairAt(long base, int index);

    /**
     * @param base  WebIDL type: {@link PxVec3}
     * @param index WebIDL type: long
     * @return WebIDL type: {@link PxVec3}
     */
    public static PxVec3 getVec3At(PxVec3 base, int index) {
        return PxVec3.wrapPointer(_getVec3At(base.getAddress(), index));
    }
    private static native long _getVec3At(long base, int index);

    /**
     * @param voidPtr WebIDL type: VoidPtr
     * @return WebIDL type: {@link PxU8ConstPtr} [Value]
     */
    public static PxU8ConstPtr voidToU8ConstPtr(NativeObject voidPtr) {
        return PxU8ConstPtr.wrapPointer(_voidToU8ConstPtr(voidPtr.getAddress()));
    }
    private static native long _voidToU8ConstPtr(long voidPtr);

    /**
     * @param voidPtr WebIDL type: VoidPtr
     * @return WebIDL type: {@link PxU16ConstPtr} [Value]
     */
    public static PxU16ConstPtr voidToU16ConstPtr(NativeObject voidPtr) {
        return PxU16ConstPtr.wrapPointer(_voidToU16ConstPtr(voidPtr.getAddress()));
    }
    private static native long _voidToU16ConstPtr(long voidPtr);

    /**
     * @param voidPtr WebIDL type: VoidPtr
     * @return WebIDL type: {@link PxU32ConstPtr} [Value]
     */
    public static PxU32ConstPtr voidToU32ConstPtr(NativeObject voidPtr) {
        return PxU32ConstPtr.wrapPointer(_voidToU32ConstPtr(voidPtr.getAddress()));
    }
    private static native long _voidToU32ConstPtr(long voidPtr);

    /**
     * @param voidPtr WebIDL type: VoidPtr
     * @return WebIDL type: {@link PxRealPtr} [Value]
     */
    public static PxRealPtr voidToRealPtr(NativeObject voidPtr) {
        return PxRealPtr.wrapPointer(_voidToRealPtr(voidPtr.getAddress()));
    }
    private static native long _voidToRealPtr(long voidPtr);

    /**
     * @param baseJoint WebIDL type: {@link PxArticulationJointBase}
     * @return WebIDL type: {@link PxArticulationJoint}
     */
    public static PxArticulationJoint articulationBaseJointToJoint(PxArticulationJointBase baseJoint) {
        return PxArticulationJoint.wrapPointer(_articulationBaseJointToJoint(baseJoint.getAddress()));
    }
    private static native long _articulationBaseJointToJoint(long baseJoint);

    /**
     * @param voidPtr WebIDL type: VoidPtr
     * @return WebIDL type: any
     */
    public static NativeObject voidToAny(NativeObject voidPtr) {
        return NativeObject.wrapPointer(_voidToAny(voidPtr.getAddress()));
    }
    private static native long _voidToAny(long voidPtr);

}
