package physx.support;

import physx.NativeObject;

public class Vector_PxReal extends NativeObject {

    public static Vector_PxReal wrapPointer(long address) {
        return address != 0L ? new Vector_PxReal(address) : null;
    }
    
    protected Vector_PxReal(long address) {
        super(address);
    }

    // Constructors

    public Vector_PxReal() {
        address = _Vector_PxReal();
    }
    private static native long _Vector_PxReal();

    /**
     * @param size WebIDL type: unsigned long
     */
    public Vector_PxReal(int size) {
        address = _Vector_PxReal(size);
    }
    private static native long _Vector_PxReal(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: float
     */
    public float at(int index) {
        checkNotNull();
        return _at(address, index);
    }
    private static native float _at(long address, int index);

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject data() {
        checkNotNull();
        return NativeObject.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: float
     */
    public void push_back(float value) {
        checkNotNull();
        _push_back(address, value);
    }
    private static native void _push_back(long address, float value);

}
