package physx.vehicle;

import physx.physics.PxPhysics;
import physx.physics.PxRigidDynamic;

public class PxVehicleDrive4W extends PxVehicleDrive {

    protected PxVehicleDrive4W() { }

    public static PxVehicleDrive4W wrapPointer(long address) {
        return address != 0L ? new PxVehicleDrive4W(address) : null;
    }
    
    protected PxVehicleDrive4W(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: {@link PxVehicleDriveSimData4W} [Value]
     */
    public PxVehicleDriveSimData4W getMDriveSimData() {
        checkNotNull();
        return PxVehicleDriveSimData4W.wrapPointer(_getMDriveSimData(address));
    }
    private static native long _getMDriveSimData(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleDriveSimData4W} [Value]
     */
    public void setMDriveSimData(PxVehicleDriveSimData4W value) {
        checkNotNull();
        _setMDriveSimData(address, value.getAddress());
    }
    private static native void _setMDriveSimData(long address, long value);

    // Functions

    /**
     * @param nbWheels WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVehicleDrive4W}
     */
    public static PxVehicleDrive4W allocate(int nbWheels) {
        return PxVehicleDrive4W.wrapPointer(_allocate(nbWheels));
    }
    private static native long _allocate(int nbWheels);

    public void free() {
        checkNotNull();
        _free(address);
    }
    private static native void _free(long address);

    /**
     * @param physics           WebIDL type: {@link PxPhysics}
     * @param vehActor          WebIDL type: {@link PxRigidDynamic}
     * @param wheelsData        WebIDL type: {@link PxVehicleWheelsSimData} [Const, Ref]
     * @param driveData         WebIDL type: {@link PxVehicleDriveSimData4W} [Const, Ref]
     * @param nbNonDrivenWheels WebIDL type: unsigned long
     */
    public void setup(PxPhysics physics, PxRigidDynamic vehActor, PxVehicleWheelsSimData wheelsData, PxVehicleDriveSimData4W driveData, int nbNonDrivenWheels) {
        checkNotNull();
        _setup(address, physics.getAddress(), vehActor.getAddress(), wheelsData.getAddress(), driveData.getAddress(), nbNonDrivenWheels);
    }
    private static native void _setup(long address, long physics, long vehActor, long wheelsData, long driveData, int nbNonDrivenWheels);

    public void setToRestState() {
        checkNotNull();
        _setToRestState(address);
    }
    private static native void _setToRestState(long address);

}
