package physx.vehicle;

import physx.physics.PxPhysics;
import physx.physics.PxRigidDynamic;

public class PxVehicleNoDrive extends PxVehicleWheels {

    protected PxVehicleNoDrive() { }

    public static PxVehicleNoDrive wrapPointer(long address) {
        return address != 0L ? new PxVehicleNoDrive(address) : null;
    }
    
    protected PxVehicleNoDrive(long address) {
        super(address);
    }

    // Functions

    /**
     * @param nbWheels WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVehicleNoDrive}
     */
    public static PxVehicleNoDrive allocate(int nbWheels) {
        return PxVehicleNoDrive.wrapPointer(_allocate(nbWheels));
    }
    private static native long _allocate(int nbWheels);

    public void free() {
        checkNotNull();
        _free(address);
    }
    private static native void _free(long address);

    /**
     * @param physics    WebIDL type: {@link PxPhysics}
     * @param vehActor   WebIDL type: {@link PxRigidDynamic}
     * @param wheelsData WebIDL type: {@link PxVehicleWheelsSimData} [Const, Ref]
     */
    public void setup(PxPhysics physics, PxRigidDynamic vehActor, PxVehicleWheelsSimData wheelsData) {
        checkNotNull();
        _setup(address, physics.getAddress(), vehActor.getAddress(), wheelsData.getAddress());
    }
    private static native void _setup(long address, long physics, long vehActor, long wheelsData);

    public void setToRestState() {
        checkNotNull();
        _setToRestState(address);
    }
    private static native void _setToRestState(long address);

    /**
     * @param id          WebIDL type: unsigned long
     * @param brakeTorque WebIDL type: float
     */
    public void setBrakeTorque(int id, float brakeTorque) {
        checkNotNull();
        _setBrakeTorque(address, id, brakeTorque);
    }
    private static native void _setBrakeTorque(long address, int id, float brakeTorque);

    /**
     * @param id          WebIDL type: unsigned long
     * @param driveTorque WebIDL type: float
     */
    public void setDriveTorque(int id, float driveTorque) {
        checkNotNull();
        _setDriveTorque(address, id, driveTorque);
    }
    private static native void _setDriveTorque(long address, int id, float driveTorque);

    /**
     * @param id         WebIDL type: unsigned long
     * @param steerAngle WebIDL type: float
     */
    public void setSteerAngle(int id, float steerAngle) {
        checkNotNull();
        _setSteerAngle(address, id, steerAngle);
    }
    private static native void _setSteerAngle(long address, int id, float steerAngle);

    /**
     * @param id WebIDL type: unsigned long
     * @return WebIDL type: float
     */
    public float getBrakeTorque(int id) {
        checkNotNull();
        return _getBrakeTorque(address, id);
    }
    private static native float _getBrakeTorque(long address, int id);

    /**
     * @param id WebIDL type: unsigned long
     * @return WebIDL type: float
     */
    public float getDriveTorque(int id) {
        checkNotNull();
        return _getDriveTorque(address, id);
    }
    private static native float _getDriveTorque(long address, int id);

    /**
     * @param id WebIDL type: unsigned long
     * @return WebIDL type: float
     */
    public float getSteerAngle(int id) {
        checkNotNull();
        return _getSteerAngle(address, id);
    }
    private static native float _getSteerAngle(long address, int id);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbSteerAngle() {
        checkNotNull();
        return _getNbSteerAngle(address);
    }
    private static native int _getNbSteerAngle(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbDriveTorque() {
        checkNotNull();
        return _getNbDriveTorque(address);
    }
    private static native int _getNbDriveTorque(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbBrakeTorque() {
        checkNotNull();
        return _getNbBrakeTorque(address);
    }
    private static native int _getNbBrakeTorque(long address);

}
