package physx.vehicle;

import physx.NativeObject;
import physx.common.PxVec3;
import physx.physics.PxFilterData;

public class PxVehicleWheelsSimData extends NativeObject {

    protected PxVehicleWheelsSimData() { }

    public static PxVehicleWheelsSimData wrapPointer(long address) {
        return address != 0L ? new PxVehicleWheelsSimData(address) : null;
    }
    
    protected PxVehicleWheelsSimData(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param nbWheels WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVehicleWheelsSimData}
     */
    public static PxVehicleWheelsSimData allocate(int nbWheels) {
        return PxVehicleWheelsSimData.wrapPointer(_allocate(nbWheels));
    }
    private static native long _allocate(int nbWheels);

    /**
     * @param chassisMass WebIDL type: float
     */
    public void setChassisMass(float chassisMass) {
        checkNotNull();
        _setChassisMass(address, chassisMass);
    }
    private static native void _setChassisMass(long address, float chassisMass);

    public void free() {
        checkNotNull();
        _free(address);
    }
    private static native void _free(long address);

    /**
     * @param src      WebIDL type: {@link PxVehicleWheelsSimData} [Const, Ref]
     * @param srcWheel WebIDL type: unsigned long
     * @param trgWheel WebIDL type: unsigned long
     */
    public void copy(PxVehicleWheelsSimData src, int srcWheel, int trgWheel) {
        checkNotNull();
        _copy(address, src.getAddress(), srcWheel, trgWheel);
    }
    private static native void _copy(long address, long src, int srcWheel, int trgWheel);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbWheels() {
        checkNotNull();
        return _getNbWheels(address);
    }
    private static native int _getNbWheels(long address);

    /**
     * @param id WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVehicleSuspensionData} [Const, Ref]
     */
    public PxVehicleSuspensionData getSuspensionData(int id) {
        checkNotNull();
        return PxVehicleSuspensionData.wrapPointer(_getSuspensionData(address, id));
    }
    private static native long _getSuspensionData(long address, int id);

    /**
     * @param id WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVehicleWheelData} [Const, Ref]
     */
    public PxVehicleWheelData getWheelData(int id) {
        checkNotNull();
        return PxVehicleWheelData.wrapPointer(_getWheelData(address, id));
    }
    private static native long _getWheelData(long address, int id);

    /**
     * @param id WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVehicleTireData} [Const, Ref]
     */
    public PxVehicleTireData getTireData(int id) {
        checkNotNull();
        return PxVehicleTireData.wrapPointer(_getTireData(address, id));
    }
    private static native long _getTireData(long address, int id);

    /**
     * @param id WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public PxVec3 getSuspTravelDirection(int id) {
        checkNotNull();
        return PxVec3.wrapPointer(_getSuspTravelDirection(address, id));
    }
    private static native long _getSuspTravelDirection(long address, int id);

    /**
     * @param id WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public PxVec3 getSuspForceAppPointOffset(int id) {
        checkNotNull();
        return PxVec3.wrapPointer(_getSuspForceAppPointOffset(address, id));
    }
    private static native long _getSuspForceAppPointOffset(long address, int id);

    /**
     * @param id WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public PxVec3 getTireForceAppPointOffset(int id) {
        checkNotNull();
        return PxVec3.wrapPointer(_getTireForceAppPointOffset(address, id));
    }
    private static native long _getTireForceAppPointOffset(long address, int id);

    /**
     * @param id WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public PxVec3 getWheelCentreOffset(int id) {
        checkNotNull();
        return PxVec3.wrapPointer(_getWheelCentreOffset(address, id));
    }
    private static native long _getWheelCentreOffset(long address, int id);

    /**
     * @param wheelId WebIDL type: unsigned long
     * @return WebIDL type: long
     */
    public int getWheelShapeMapping(int wheelId) {
        checkNotNull();
        return _getWheelShapeMapping(address, wheelId);
    }
    private static native int _getWheelShapeMapping(long address, int wheelId);

    /**
     * @param suspId WebIDL type: unsigned long
     * @return WebIDL type: {@link PxFilterData} [Const, Ref]
     */
    public PxFilterData getSceneQueryFilterData(int suspId) {
        checkNotNull();
        return PxFilterData.wrapPointer(_getSceneQueryFilterData(address, suspId));
    }
    private static native long _getSceneQueryFilterData(long address, int suspId);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbAntiRollBars() {
        checkNotNull();
        return _getNbAntiRollBars(address);
    }
    private static native int _getNbAntiRollBars(long address);

    /**
     * @param antiRollId WebIDL type: unsigned long
     * @return WebIDL type: {@link PxVehicleAntiRollBarData} [Const, Ref]
     */
    public PxVehicleAntiRollBarData getAntiRollBarData(int antiRollId) {
        checkNotNull();
        return PxVehicleAntiRollBarData.wrapPointer(_getAntiRollBarData(address, antiRollId));
    }
    private static native long _getAntiRollBarData(long address, int antiRollId);

    /**
     * @return WebIDL type: {@link PxVehicleTireLoadFilterData} [Const, Ref]
     */
    public PxVehicleTireLoadFilterData getTireLoadFilterData() {
        checkNotNull();
        return PxVehicleTireLoadFilterData.wrapPointer(_getTireLoadFilterData(address));
    }
    private static native long _getTireLoadFilterData(long address);

    /**
     * @param id   WebIDL type: unsigned long
     * @param susp WebIDL type: {@link PxVehicleSuspensionData} [Const, Ref]
     */
    public void setSuspensionData(int id, PxVehicleSuspensionData susp) {
        checkNotNull();
        _setSuspensionData(address, id, susp.getAddress());
    }
    private static native void _setSuspensionData(long address, int id, long susp);

    /**
     * @param id    WebIDL type: unsigned long
     * @param wheel WebIDL type: {@link PxVehicleWheelData} [Const, Ref]
     */
    public void setWheelData(int id, PxVehicleWheelData wheel) {
        checkNotNull();
        _setWheelData(address, id, wheel.getAddress());
    }
    private static native void _setWheelData(long address, int id, long wheel);

    /**
     * @param id   WebIDL type: unsigned long
     * @param tire WebIDL type: {@link PxVehicleTireData} [Const, Ref]
     */
    public void setTireData(int id, PxVehicleTireData tire) {
        checkNotNull();
        _setTireData(address, id, tire.getAddress());
    }
    private static native void _setTireData(long address, int id, long tire);

    /**
     * @param id  WebIDL type: unsigned long
     * @param dir WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setSuspTravelDirection(int id, PxVec3 dir) {
        checkNotNull();
        _setSuspTravelDirection(address, id, dir.getAddress());
    }
    private static native void _setSuspTravelDirection(long address, int id, long dir);

    /**
     * @param id     WebIDL type: unsigned long
     * @param offset WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setSuspForceAppPointOffset(int id, PxVec3 offset) {
        checkNotNull();
        _setSuspForceAppPointOffset(address, id, offset.getAddress());
    }
    private static native void _setSuspForceAppPointOffset(long address, int id, long offset);

    /**
     * @param id     WebIDL type: unsigned long
     * @param offset WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setTireForceAppPointOffset(int id, PxVec3 offset) {
        checkNotNull();
        _setTireForceAppPointOffset(address, id, offset.getAddress());
    }
    private static native void _setTireForceAppPointOffset(long address, int id, long offset);

    /**
     * @param id     WebIDL type: unsigned long
     * @param offset WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public void setWheelCentreOffset(int id, PxVec3 offset) {
        checkNotNull();
        _setWheelCentreOffset(address, id, offset.getAddress());
    }
    private static native void _setWheelCentreOffset(long address, int id, long offset);

    /**
     * @param wheelId WebIDL type: unsigned long
     * @param shapeId WebIDL type: long
     */
    public void setWheelShapeMapping(int wheelId, int shapeId) {
        checkNotNull();
        _setWheelShapeMapping(address, wheelId, shapeId);
    }
    private static native void _setWheelShapeMapping(long address, int wheelId, int shapeId);

    /**
     * @param suspId       WebIDL type: unsigned long
     * @param sqFilterData WebIDL type: {@link PxFilterData} [Const, Ref]
     */
    public void setSceneQueryFilterData(int suspId, PxFilterData sqFilterData) {
        checkNotNull();
        _setSceneQueryFilterData(address, suspId, sqFilterData.getAddress());
    }
    private static native void _setSceneQueryFilterData(long address, int suspId, long sqFilterData);

    /**
     * @param tireLoadFilter WebIDL type: {@link PxVehicleTireLoadFilterData} [Const, Ref]
     */
    public void setTireLoadFilterData(PxVehicleTireLoadFilterData tireLoadFilter) {
        checkNotNull();
        _setTireLoadFilterData(address, tireLoadFilter.getAddress());
    }
    private static native void _setTireLoadFilterData(long address, long tireLoadFilter);

    /**
     * @param antiRoll WebIDL type: {@link PxVehicleAntiRollBarData} [Const, Ref]
     * @return WebIDL type: unsigned long
     */
    public int addAntiRollBarData(PxVehicleAntiRollBarData antiRoll) {
        checkNotNull();
        return _addAntiRollBarData(address, antiRoll.getAddress());
    }
    private static native int _addAntiRollBarData(long address, long antiRoll);

    /**
     * @param wheel WebIDL type: unsigned long
     */
    public void disableWheel(int wheel) {
        checkNotNull();
        _disableWheel(address, wheel);
    }
    private static native void _disableWheel(long address, int wheel);

    /**
     * @param wheel WebIDL type: unsigned long
     */
    public void enableWheel(int wheel) {
        checkNotNull();
        _enableWheel(address, wheel);
    }
    private static native void _enableWheel(long address, int wheel);

    /**
     * @param wheel WebIDL type: unsigned long
     * @return WebIDL type: boolean
     */
    public boolean getIsWheelDisabled(int wheel) {
        checkNotNull();
        return _getIsWheelDisabled(address, wheel);
    }
    private static native boolean _getIsWheelDisabled(long address, int wheel);

    /**
     * @param thresholdLongitudinalSpeed   WebIDL type: float
     * @param lowForwardSpeedSubStepCount  WebIDL type: unsigned long
     * @param highForwardSpeedSubStepCount WebIDL type: unsigned long
     */
    public void setSubStepCount(float thresholdLongitudinalSpeed, int lowForwardSpeedSubStepCount, int highForwardSpeedSubStepCount) {
        checkNotNull();
        _setSubStepCount(address, thresholdLongitudinalSpeed, lowForwardSpeedSubStepCount, highForwardSpeedSubStepCount);
    }
    private static native void _setSubStepCount(long address, float thresholdLongitudinalSpeed, int lowForwardSpeedSubStepCount, int highForwardSpeedSubStepCount);

    /**
     * @param minLongSlipDenominator WebIDL type: float
     */
    public void setMinLongSlipDenominator(float minLongSlipDenominator) {
        checkNotNull();
        _setMinLongSlipDenominator(address, minLongSlipDenominator);
    }
    private static native void _setMinLongSlipDenominator(long address, float minLongSlipDenominator);

    /**
     * @param flags WebIDL type: {@link PxVehicleWheelsSimFlags} [Ref]
     */
    public void setFlags(PxVehicleWheelsSimFlags flags) {
        checkNotNull();
        _setFlags(address, flags.getAddress());
    }
    private static native void _setFlags(long address, long flags);

    /**
     * @return WebIDL type: {@link PxVehicleWheelsSimFlags} [Value]
     */
    public PxVehicleWheelsSimFlags getFlags() {
        checkNotNull();
        return PxVehicleWheelsSimFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbWheels4() {
        checkNotNull();
        return _getNbWheels4(address);
    }
    private static native int _getNbWheels4(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbSuspensionData() {
        checkNotNull();
        return _getNbSuspensionData(address);
    }
    private static native int _getNbSuspensionData(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelData() {
        checkNotNull();
        return _getNbWheelData(address);
    }
    private static native int _getNbWheelData(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbSuspTravelDirection() {
        checkNotNull();
        return _getNbSuspTravelDirection(address);
    }
    private static native int _getNbSuspTravelDirection(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbTireData() {
        checkNotNull();
        return _getNbTireData(address);
    }
    private static native int _getNbTireData(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbSuspForceAppPointOffset() {
        checkNotNull();
        return _getNbSuspForceAppPointOffset(address);
    }
    private static native int _getNbSuspForceAppPointOffset(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbTireForceAppPointOffset() {
        checkNotNull();
        return _getNbTireForceAppPointOffset(address);
    }
    private static native int _getNbTireForceAppPointOffset(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelCentreOffset() {
        checkNotNull();
        return _getNbWheelCentreOffset(address);
    }
    private static native int _getNbWheelCentreOffset(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelShapeMapping() {
        checkNotNull();
        return _getNbWheelShapeMapping(address);
    }
    private static native int _getNbWheelShapeMapping(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbSceneQueryFilterData() {
        checkNotNull();
        return _getNbSceneQueryFilterData(address);
    }
    private static native int _getNbSceneQueryFilterData(long address);

    /**
     * @return WebIDL type: float
     */
    public float getMinLongSlipDenominator() {
        checkNotNull();
        return _getMinLongSlipDenominator(address);
    }
    private static native float _getMinLongSlipDenominator(long address);

    /**
     * @param f WebIDL type: float
     */
    public void setThresholdLongSpeed(float f) {
        checkNotNull();
        _setThresholdLongSpeed(address, f);
    }
    private static native void _setThresholdLongSpeed(long address, float f);

    /**
     * @return WebIDL type: float
     */
    public float getThresholdLongSpeed() {
        checkNotNull();
        return _getThresholdLongSpeed(address);
    }
    private static native float _getThresholdLongSpeed(long address);

    /**
     * @param f WebIDL type: unsigned long
     */
    public void setLowForwardSpeedSubStepCount(int f) {
        checkNotNull();
        _setLowForwardSpeedSubStepCount(address, f);
    }
    private static native void _setLowForwardSpeedSubStepCount(long address, int f);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getLowForwardSpeedSubStepCount() {
        checkNotNull();
        return _getLowForwardSpeedSubStepCount(address);
    }
    private static native int _getLowForwardSpeedSubStepCount(long address);

    /**
     * @param f WebIDL type: unsigned long
     */
    public void setHighForwardSpeedSubStepCount(int f) {
        checkNotNull();
        _setHighForwardSpeedSubStepCount(address, f);
    }
    private static native void _setHighForwardSpeedSubStepCount(long address, int f);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getHighForwardSpeedSubStepCount() {
        checkNotNull();
        return _getHighForwardSpeedSubStepCount(address);
    }
    private static native int _getHighForwardSpeedSubStepCount(long address);

    /**
     * @param wheel WebIDL type: unsigned long
     * @param state WebIDL type: boolean
     */
    public void setWheelEnabledState(int wheel, boolean state) {
        checkNotNull();
        _setWheelEnabledState(address, wheel, state);
    }
    private static native void _setWheelEnabledState(long address, int wheel, boolean state);

    /**
     * @param wheel WebIDL type: unsigned long
     * @return WebIDL type: boolean
     */
    public boolean getWheelEnabledState(int wheel) {
        checkNotNull();
        return _getWheelEnabledState(address, wheel);
    }
    private static native boolean _getWheelEnabledState(long address, int wheel);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelEnabledState() {
        checkNotNull();
        return _getNbWheelEnabledState(address);
    }
    private static native int _getNbWheelEnabledState(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbAntiRollBars4() {
        checkNotNull();
        return _getNbAntiRollBars4(address);
    }
    private static native int _getNbAntiRollBars4(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbAntiRollBarData() {
        checkNotNull();
        return _getNbAntiRollBarData(address);
    }
    private static native int _getNbAntiRollBarData(long address);

    /**
     * @param id       WebIDL type: unsigned long
     * @param antiRoll WebIDL type: {@link PxVehicleAntiRollBarData} [Const, Ref]
     */
    public void setAntiRollBarData(int id, PxVehicleAntiRollBarData antiRoll) {
        checkNotNull();
        _setAntiRollBarData(address, id, antiRoll.getAddress());
    }
    private static native void _setAntiRollBarData(long address, int id, long antiRoll);

}
