package physx.character;

import physx.NativeObject;

public class PxControllerFilterCallback extends NativeObject {

    protected PxControllerFilterCallback() { }

    public static PxControllerFilterCallback wrapPointer(long address) {
        return address != 0L ? new PxControllerFilterCallback(address) : null;
    }
    
    protected PxControllerFilterCallback(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param a WebIDL type: {@link PxController} [Const, Ref]
     * @param b WebIDL type: {@link PxController} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean filter(PxController a, PxController b) {
        checkNotNull();
        return _filter(address, a.getAddress(), b.getAddress());
    }
    private static native boolean _filter(long address, long a, long b);

}
