package physx.character;

import physx.NativeObject;

public class PxControllerStats extends NativeObject {

    protected PxControllerStats() { }

    public static PxControllerStats wrapPointer(long address) {
        return address != 0L ? new PxControllerStats(address) : null;
    }
    
    protected PxControllerStats(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: unsigned short
     */
    public short getNbIterations() {
        checkNotNull();
        return _getNbIterations(address);
    }
    private static native short _getNbIterations(long address);

    /**
     * @param value WebIDL type: unsigned short
     */
    public void setNbIterations(short value) {
        checkNotNull();
        _setNbIterations(address, value);
    }
    private static native void _setNbIterations(long address, short value);

    /**
     * @return WebIDL type: unsigned short
     */
    public short getNbFullUpdates() {
        checkNotNull();
        return _getNbFullUpdates(address);
    }
    private static native short _getNbFullUpdates(long address);

    /**
     * @param value WebIDL type: unsigned short
     */
    public void setNbFullUpdates(short value) {
        checkNotNull();
        _setNbFullUpdates(address, value);
    }
    private static native void _setNbFullUpdates(long address, short value);

    /**
     * @return WebIDL type: unsigned short
     */
    public short getNbPartialUpdates() {
        checkNotNull();
        return _getNbPartialUpdates(address);
    }
    private static native short _getNbPartialUpdates(long address);

    /**
     * @param value WebIDL type: unsigned short
     */
    public void setNbPartialUpdates(short value) {
        checkNotNull();
        _setNbPartialUpdates(address, value);
    }
    private static native void _setNbPartialUpdates(long address, short value);

    /**
     * @return WebIDL type: unsigned short
     */
    public short getNbTessellation() {
        checkNotNull();
        return _getNbTessellation(address);
    }
    private static native short _getNbTessellation(long address);

    /**
     * @param value WebIDL type: unsigned short
     */
    public void setNbTessellation(short value) {
        checkNotNull();
        _setNbTessellation(address, value);
    }
    private static native void _setNbTessellation(long address, short value);

}
