package physx.character;

import physx.NativeObject;

public class PxExtendedVec3 extends NativeObject {

    public static PxExtendedVec3 wrapPointer(long address) {
        return address != 0L ? new PxExtendedVec3(address) : null;
    }
    
    protected PxExtendedVec3(long address) {
        super(address);
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxExtendedVec3
     */
    public static PxExtendedVec3 createAt(long address) {
        __placement_new_PxExtendedVec3(address);
        PxExtendedVec3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxExtendedVec3
     */
    public static <T> PxExtendedVec3 createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxExtendedVec3(address);
        PxExtendedVec3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxExtendedVec3(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param x       WebIDL type: double
     * @param y       WebIDL type: double
     * @param z       WebIDL type: double
     * @return Stack allocated object of PxExtendedVec3
     */
    public static PxExtendedVec3 createAt(long address, double x, double y, double z) {
        __placement_new_PxExtendedVec3(address, x, y, z);
        PxExtendedVec3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param x         WebIDL type: double
     * @param y         WebIDL type: double
     * @param z         WebIDL type: double
     * @return Stack allocated object of PxExtendedVec3
     */
    public static <T> PxExtendedVec3 createAt(T allocator, Allocator<T> allocate, double x, double y, double z) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxExtendedVec3(address, x, y, z);
        PxExtendedVec3 createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxExtendedVec3(long address, double x, double y, double z);

    // Constructors

    public PxExtendedVec3() {
        address = _PxExtendedVec3();
    }
    private static native long _PxExtendedVec3();

    /**
     * @param x WebIDL type: double
     * @param y WebIDL type: double
     * @param z WebIDL type: double
     */
    public PxExtendedVec3(double x, double y, double z) {
        address = _PxExtendedVec3(x, y, z);
    }
    private static native long _PxExtendedVec3(double x, double y, double z);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: double
     */
    public double getX() {
        checkNotNull();
        return _getX(address);
    }
    private static native double _getX(long address);

    /**
     * @param value WebIDL type: double
     */
    public void setX(double value) {
        checkNotNull();
        _setX(address, value);
    }
    private static native void _setX(long address, double value);

    /**
     * @return WebIDL type: double
     */
    public double getY() {
        checkNotNull();
        return _getY(address);
    }
    private static native double _getY(long address);

    /**
     * @param value WebIDL type: double
     */
    public void setY(double value) {
        checkNotNull();
        _setY(address, value);
    }
    private static native void _setY(long address, double value);

    /**
     * @return WebIDL type: double
     */
    public double getZ() {
        checkNotNull();
        return _getZ(address);
    }
    private static native double _getZ(long address);

    /**
     * @param value WebIDL type: double
     */
    public void setZ(double value) {
        checkNotNull();
        _setZ(address, value);
    }
    private static native void _setZ(long address, double value);

}
