package physx.extensions;


public class PxJointLimitPyramid extends PxJointLimitParameters {

    protected PxJointLimitPyramid() { }

    public static PxJointLimitPyramid wrapPointer(long address) {
        return address != 0L ? new PxJointLimitPyramid(address) : null;
    }
    
    protected PxJointLimitPyramid(long address) {
        super(address);
    }

    // Constructors

    /**
     * @param yLimitAngleMin WebIDL type: float
     * @param yLimitAngleMax WebIDL type: float
     * @param zLimitAngleMin WebIDL type: float
     * @param zLimitAngleMax WebIDL type: float
     * @param spring         WebIDL type: {@link PxSpring} [Const, Ref]
     */
    public PxJointLimitPyramid(float yLimitAngleMin, float yLimitAngleMax, float zLimitAngleMin, float zLimitAngleMax, PxSpring spring) {
        address = _PxJointLimitPyramid(yLimitAngleMin, yLimitAngleMax, zLimitAngleMin, zLimitAngleMax, spring.getAddress());
    }
    private static native long _PxJointLimitPyramid(float yLimitAngleMin, float yLimitAngleMax, float zLimitAngleMin, float zLimitAngleMax, long spring);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getYAngleMin() {
        checkNotNull();
        return _getYAngleMin(address);
    }
    private static native float _getYAngleMin(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setYAngleMin(float value) {
        checkNotNull();
        _setYAngleMin(address, value);
    }
    private static native void _setYAngleMin(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getYAngleMax() {
        checkNotNull();
        return _getYAngleMax(address);
    }
    private static native float _getYAngleMax(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setYAngleMax(float value) {
        checkNotNull();
        _setYAngleMax(address, value);
    }
    private static native void _setYAngleMax(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getZAngleMin() {
        checkNotNull();
        return _getZAngleMin(address);
    }
    private static native float _getZAngleMin(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setZAngleMin(float value) {
        checkNotNull();
        _setZAngleMin(address, value);
    }
    private static native void _setZAngleMin(long address, float value);

    /**
     * @return WebIDL type: float
     */
    public float getZAngleMax() {
        checkNotNull();
        return _getZAngleMax(address);
    }
    private static native float _getZAngleMax(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setZAngleMax(float value) {
        checkNotNull();
        _setZAngleMax(address, value);
    }
    private static native void _setZAngleMax(long address, float value);

}
