package physx.extensions;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.geomutils.PxGeometry;
import physx.geomutils.PxTriangleMeshGeometry;
import physx.support.PxU32ConstPtr;

public class PxMeshOverlapUtil extends NativeObject {

    public static PxMeshOverlapUtil wrapPointer(long address) {
        return address != 0L ? new PxMeshOverlapUtil(address) : null;
    }
    
    protected PxMeshOverlapUtil(long address) {
        super(address);
    }

    // Constructors

    public PxMeshOverlapUtil() {
        address = _PxMeshOverlapUtil();
    }
    private static native long _PxMeshOverlapUtil();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param geom     WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param geomPose WebIDL type: {@link PxTransform} [Const, Ref]
     * @param meshGeom WebIDL type: {@link PxTriangleMeshGeometry} [Const, Ref]
     * @param meshPose WebIDL type: {@link PxTransform} [Const, Ref]
     * @return WebIDL type: unsigned long
     */
    public int findOverlap(PxGeometry geom, PxTransform geomPose, PxTriangleMeshGeometry meshGeom, PxTransform meshPose) {
        checkNotNull();
        return _findOverlap(address, geom.getAddress(), geomPose.getAddress(), meshGeom.getAddress(), meshPose.getAddress());
    }
    private static native int _findOverlap(long address, long geom, long geomPose, long meshGeom, long meshPose);

    /**
     * @return WebIDL type: {@link PxU32ConstPtr} [Value]
     */
    public PxU32ConstPtr getResults() {
        checkNotNull();
        return PxU32ConstPtr.wrapPointer(_getResults(address));
    }
    private static native long _getResults(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int getNbResults() {
        checkNotNull();
        return _getNbResults(address);
    }
    private static native int _getNbResults(long address);

}
