package physx.geomutils;

import physx.NativeObject;

public class PxGeometryHolder extends NativeObject {

    public static PxGeometryHolder wrapPointer(long address) {
        return address != 0L ? new PxGeometryHolder(address) : null;
    }
    
    protected PxGeometryHolder(long address) {
        super(address);
    }

    // Constructors

    public PxGeometryHolder() {
        address = _PxGeometryHolder();
    }
    private static native long _PxGeometryHolder();

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     */
    public PxGeometryHolder(PxGeometry geometry) {
        address = _PxGeometryHolder(geometry.getAddress());
    }
    private static native long _PxGeometryHolder(long geometry);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @return WebIDL type: {@link PxGeometryTypeEnum} [enum]
     */
    public int getType() {
        checkNotNull();
        return _getType(address);
    }
    private static native int _getType(long address);

    /**
     * @return WebIDL type: {@link PxSphereGeometry} [Ref]
     */
    public PxSphereGeometry sphere() {
        checkNotNull();
        return PxSphereGeometry.wrapPointer(_sphere(address));
    }
    private static native long _sphere(long address);

    /**
     * @return WebIDL type: {@link PxPlaneGeometry} [Ref]
     */
    public PxPlaneGeometry plane() {
        checkNotNull();
        return PxPlaneGeometry.wrapPointer(_plane(address));
    }
    private static native long _plane(long address);

    /**
     * @return WebIDL type: {@link PxCapsuleGeometry} [Ref]
     */
    public PxCapsuleGeometry capsule() {
        checkNotNull();
        return PxCapsuleGeometry.wrapPointer(_capsule(address));
    }
    private static native long _capsule(long address);

    /**
     * @return WebIDL type: {@link PxBoxGeometry} [Ref]
     */
    public PxBoxGeometry box() {
        checkNotNull();
        return PxBoxGeometry.wrapPointer(_box(address));
    }
    private static native long _box(long address);

    /**
     * @return WebIDL type: {@link PxConvexMeshGeometry} [Ref]
     */
    public PxConvexMeshGeometry convexMesh() {
        checkNotNull();
        return PxConvexMeshGeometry.wrapPointer(_convexMesh(address));
    }
    private static native long _convexMesh(long address);

    /**
     * @return WebIDL type: {@link PxTriangleMeshGeometry} [Ref]
     */
    public PxTriangleMeshGeometry triangleMesh() {
        checkNotNull();
        return PxTriangleMeshGeometry.wrapPointer(_triangleMesh(address));
    }
    private static native long _triangleMesh(long address);

    /**
     * @return WebIDL type: {@link PxHeightFieldGeometry} [Ref]
     */
    public PxHeightFieldGeometry heightField() {
        checkNotNull();
        return PxHeightFieldGeometry.wrapPointer(_heightField(address));
    }
    private static native long _heightField(long address);

    /**
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     */
    public void storeAny(PxGeometry geometry) {
        checkNotNull();
        _storeAny(address, geometry.getAddress());
    }
    private static native void _storeAny(long address, long geometry);

}
