package physx.physics;

import physx.NativeObject;
import physx.common.PxBase;

public class PxMaterial extends PxBase {

    protected PxMaterial() { }

    public static PxMaterial wrapPointer(long address) {
        return address != 0L ? new PxMaterial(address) : null;
    }
    
    protected PxMaterial(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: VoidPtr
     */
    public NativeObject getUserData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getUserData(address));
    }
    private static native long _getUserData(long address);

    /**
     * @param value WebIDL type: VoidPtr
     */
    public void setUserData(NativeObject value) {
        checkNotNull();
        _setUserData(address, value.getAddress());
    }
    private static native void _setUserData(long address, long value);

    // Functions

    /**
     * @return WebIDL type: unsigned long
     */
    public int getReferenceCount() {
        checkNotNull();
        return _getReferenceCount(address);
    }
    private static native int _getReferenceCount(long address);

    public void acquireReference() {
        checkNotNull();
        _acquireReference(address);
    }
    private static native void _acquireReference(long address);

    /**
     * @param coef WebIDL type: float
     */
    public void setDynamicFriction(float coef) {
        checkNotNull();
        _setDynamicFriction(address, coef);
    }
    private static native void _setDynamicFriction(long address, float coef);

    /**
     * @return WebIDL type: float
     */
    public float getDynamicFriction() {
        checkNotNull();
        return _getDynamicFriction(address);
    }
    private static native float _getDynamicFriction(long address);

    /**
     * @param coef WebIDL type: float
     */
    public void setStaticFriction(float coef) {
        checkNotNull();
        _setStaticFriction(address, coef);
    }
    private static native void _setStaticFriction(long address, float coef);

    /**
     * @return WebIDL type: float
     */
    public float getStaticFriction() {
        checkNotNull();
        return _getStaticFriction(address);
    }
    private static native float _getStaticFriction(long address);

    /**
     * @param coef WebIDL type: float
     */
    public void setRestitution(float coef) {
        checkNotNull();
        _setRestitution(address, coef);
    }
    private static native void _setRestitution(long address, float coef);

    /**
     * @return WebIDL type: float
     */
    public float getRestitution() {
        checkNotNull();
        return _getRestitution(address);
    }
    private static native float _getRestitution(long address);

    /**
     * @param flag WebIDL type: {@link PxMaterialFlagEnum} [enum]
     * @param b    WebIDL type: boolean
     */
    public void setFlag(int flag, boolean b) {
        checkNotNull();
        _setFlag(address, flag, b);
    }
    private static native void _setFlag(long address, int flag, boolean b);

    /**
     * @param flags WebIDL type: {@link PxMaterialFlags} [Ref]
     */
    public void setFlags(PxMaterialFlags flags) {
        checkNotNull();
        _setFlags(address, flags.getAddress());
    }
    private static native void _setFlags(long address, long flags);

    /**
     * @return WebIDL type: {@link PxMaterialFlags} [Value]
     */
    public PxMaterialFlags getFlags() {
        checkNotNull();
        return PxMaterialFlags.wrapPointer(_getFlags(address));
    }
    private static native long _getFlags(long address);

    /**
     * @param combMode WebIDL type: {@link PxCombineModeEnum} [enum]
     */
    public void setFrictionCombineMode(int combMode) {
        checkNotNull();
        _setFrictionCombineMode(address, combMode);
    }
    private static native void _setFrictionCombineMode(long address, int combMode);

    /**
     * @return WebIDL type: {@link PxCombineModeEnum} [enum]
     */
    public int getFrictionCombineMode() {
        checkNotNull();
        return _getFrictionCombineMode(address);
    }
    private static native int _getFrictionCombineMode(long address);

    /**
     * @param combMode WebIDL type: {@link PxCombineModeEnum} [enum]
     */
    public void setRestitutionCombineMode(int combMode) {
        checkNotNull();
        _setRestitutionCombineMode(address, combMode);
    }
    private static native void _setRestitutionCombineMode(long address, int combMode);

    /**
     * @return WebIDL type: {@link PxCombineModeEnum} [enum]
     */
    public int getRestitutionCombineMode() {
        checkNotNull();
        return _getRestitutionCombineMode(address);
    }
    private static native int _getRestitutionCombineMode(long address);

}
