package physx.physics;

import physx.NativeObject;

public class PxQueryFilterCallback extends NativeObject {

    protected PxQueryFilterCallback() { }

    public static PxQueryFilterCallback wrapPointer(long address) {
        return address != 0L ? new PxQueryFilterCallback(address) : null;
    }
    
    protected PxQueryFilterCallback(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
