package physx.physics;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.geomutils.PxGeometry;

public class PxSceneQueryExt extends NativeObject {

    protected PxSceneQueryExt() { }

    public static PxSceneQueryExt wrapPointer(long address) {
        return address != 0L ? new PxSceneQueryExt(address) : null;
    }
    
    protected PxSceneQueryExt(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param scene    WebIDL type: {@link PxScene} [Const, Ref]
     * @param origin   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir  WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance WebIDL type: float [Const]
     * @param hit      WebIDL type: {@link PxQueryHit} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean raycastAny(PxScene scene, PxVec3 origin, PxVec3 unitDir, float distance, PxQueryHit hit) {
        return _raycastAny(scene.getAddress(), origin.getAddress(), unitDir.getAddress(), distance, hit.getAddress());
    }
    private static native boolean _raycastAny(long scene, long origin, long unitDir, float distance, long hit);

    /**
     * @param scene      WebIDL type: {@link PxScene} [Const, Ref]
     * @param origin     WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance   WebIDL type: float [Const]
     * @param hit        WebIDL type: {@link PxQueryHit} [Ref]
     * @param filterData WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public static boolean raycastAny(PxScene scene, PxVec3 origin, PxVec3 unitDir, float distance, PxQueryHit hit, PxQueryFilterData filterData) {
        return _raycastAny(scene.getAddress(), origin.getAddress(), unitDir.getAddress(), distance, hit.getAddress(), filterData.getAddress());
    }
    private static native boolean _raycastAny(long scene, long origin, long unitDir, float distance, long hit, long filterData);

    /**
     * @param scene      WebIDL type: {@link PxScene} [Const, Ref]
     * @param origin     WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance   WebIDL type: float [Const]
     * @param hit        WebIDL type: {@link PxQueryHit} [Ref]
     * @param filterData WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @param filterCall WebIDL type: {@link PxQueryFilterCallback}
     * @return WebIDL type: boolean
     */
    public static boolean raycastAny(PxScene scene, PxVec3 origin, PxVec3 unitDir, float distance, PxQueryHit hit, PxQueryFilterData filterData, PxQueryFilterCallback filterCall) {
        return _raycastAny(scene.getAddress(), origin.getAddress(), unitDir.getAddress(), distance, hit.getAddress(), filterData.getAddress(), filterCall.getAddress());
    }
    private static native boolean _raycastAny(long scene, long origin, long unitDir, float distance, long hit, long filterData, long filterCall);

    /**
     * @param scene       WebIDL type: {@link PxScene} [Const, Ref]
     * @param origin      WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir     WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance    WebIDL type: float [Const]
     * @param outputFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @param hit         WebIDL type: {@link PxRaycastHit} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean raycastSingle(PxScene scene, PxVec3 origin, PxVec3 unitDir, float distance, PxHitFlags outputFlags, PxRaycastHit hit) {
        return _raycastSingle(scene.getAddress(), origin.getAddress(), unitDir.getAddress(), distance, outputFlags.getAddress(), hit.getAddress());
    }
    private static native boolean _raycastSingle(long scene, long origin, long unitDir, float distance, long outputFlags, long hit);

    /**
     * @param scene       WebIDL type: {@link PxScene} [Const, Ref]
     * @param origin      WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir     WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance    WebIDL type: float [Const]
     * @param outputFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @param hit         WebIDL type: {@link PxRaycastHit} [Ref]
     * @param filterData  WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public static boolean raycastSingle(PxScene scene, PxVec3 origin, PxVec3 unitDir, float distance, PxHitFlags outputFlags, PxRaycastHit hit, PxQueryFilterData filterData) {
        return _raycastSingle(scene.getAddress(), origin.getAddress(), unitDir.getAddress(), distance, outputFlags.getAddress(), hit.getAddress(), filterData.getAddress());
    }
    private static native boolean _raycastSingle(long scene, long origin, long unitDir, float distance, long outputFlags, long hit, long filterData);

    /**
     * @param scene       WebIDL type: {@link PxScene} [Const, Ref]
     * @param origin      WebIDL type: {@link PxVec3} [Const, Ref]
     * @param unitDir     WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance    WebIDL type: float [Const]
     * @param outputFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @param hit         WebIDL type: {@link PxRaycastHit} [Ref]
     * @param filterData  WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @param filterCall  WebIDL type: {@link PxQueryFilterCallback}
     * @return WebIDL type: boolean
     */
    public static boolean raycastSingle(PxScene scene, PxVec3 origin, PxVec3 unitDir, float distance, PxHitFlags outputFlags, PxRaycastHit hit, PxQueryFilterData filterData, PxQueryFilterCallback filterCall) {
        return _raycastSingle(scene.getAddress(), origin.getAddress(), unitDir.getAddress(), distance, outputFlags.getAddress(), hit.getAddress(), filterData.getAddress(), filterCall.getAddress());
    }
    private static native boolean _raycastSingle(long scene, long origin, long unitDir, float distance, long outputFlags, long hit, long filterData, long filterCall);

    /**
     * @param scene      WebIDL type: {@link PxScene} [Const, Ref]
     * @param geometry   WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose       WebIDL type: {@link PxTransform} [Const, Ref]
     * @param unitDir    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance   WebIDL type: float [Const]
     * @param queryFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @param hit        WebIDL type: {@link PxQueryHit} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean sweepAny(PxScene scene, PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxHitFlags queryFlags, PxQueryHit hit) {
        return _sweepAny(scene.getAddress(), geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, queryFlags.getAddress(), hit.getAddress());
    }
    private static native boolean _sweepAny(long scene, long geometry, long pose, long unitDir, float distance, long queryFlags, long hit);

    /**
     * @param scene      WebIDL type: {@link PxScene} [Const, Ref]
     * @param geometry   WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose       WebIDL type: {@link PxTransform} [Const, Ref]
     * @param unitDir    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance   WebIDL type: float [Const]
     * @param queryFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @param hit        WebIDL type: {@link PxQueryHit} [Ref]
     * @param filterData WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public static boolean sweepAny(PxScene scene, PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxHitFlags queryFlags, PxQueryHit hit, PxQueryFilterData filterData) {
        return _sweepAny(scene.getAddress(), geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, queryFlags.getAddress(), hit.getAddress(), filterData.getAddress());
    }
    private static native boolean _sweepAny(long scene, long geometry, long pose, long unitDir, float distance, long queryFlags, long hit, long filterData);

    /**
     * @param scene      WebIDL type: {@link PxScene} [Const, Ref]
     * @param geometry   WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose       WebIDL type: {@link PxTransform} [Const, Ref]
     * @param unitDir    WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance   WebIDL type: float [Const]
     * @param queryFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @param hit        WebIDL type: {@link PxQueryHit} [Ref]
     * @param filterData WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @param filterCall WebIDL type: {@link PxQueryFilterCallback}
     * @return WebIDL type: boolean
     */
    public static boolean sweepAny(PxScene scene, PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxHitFlags queryFlags, PxQueryHit hit, PxQueryFilterData filterData, PxQueryFilterCallback filterCall) {
        return _sweepAny(scene.getAddress(), geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, queryFlags.getAddress(), hit.getAddress(), filterData.getAddress(), filterCall.getAddress());
    }
    private static native boolean _sweepAny(long scene, long geometry, long pose, long unitDir, float distance, long queryFlags, long hit, long filterData, long filterCall);

    /**
     * @param scene       WebIDL type: {@link PxScene} [Const, Ref]
     * @param geometry    WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose        WebIDL type: {@link PxTransform} [Const, Ref]
     * @param unitDir     WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance    WebIDL type: float [Const]
     * @param outputFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @param hit         WebIDL type: {@link PxSweepHit} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean sweepSingle(PxScene scene, PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxHitFlags outputFlags, PxSweepHit hit) {
        return _sweepSingle(scene.getAddress(), geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, outputFlags.getAddress(), hit.getAddress());
    }
    private static native boolean _sweepSingle(long scene, long geometry, long pose, long unitDir, float distance, long outputFlags, long hit);

    /**
     * @param scene       WebIDL type: {@link PxScene} [Const, Ref]
     * @param geometry    WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose        WebIDL type: {@link PxTransform} [Const, Ref]
     * @param unitDir     WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance    WebIDL type: float [Const]
     * @param outputFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @param hit         WebIDL type: {@link PxSweepHit} [Ref]
     * @param filterData  WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public static boolean sweepSingle(PxScene scene, PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxHitFlags outputFlags, PxSweepHit hit, PxQueryFilterData filterData) {
        return _sweepSingle(scene.getAddress(), geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, outputFlags.getAddress(), hit.getAddress(), filterData.getAddress());
    }
    private static native boolean _sweepSingle(long scene, long geometry, long pose, long unitDir, float distance, long outputFlags, long hit, long filterData);

    /**
     * @param scene       WebIDL type: {@link PxScene} [Const, Ref]
     * @param geometry    WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose        WebIDL type: {@link PxTransform} [Const, Ref]
     * @param unitDir     WebIDL type: {@link PxVec3} [Const, Ref]
     * @param distance    WebIDL type: float [Const]
     * @param outputFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @param hit         WebIDL type: {@link PxSweepHit} [Ref]
     * @param filterData  WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @param filterCall  WebIDL type: {@link PxQueryFilterCallback}
     * @return WebIDL type: boolean
     */
    public static boolean sweepSingle(PxScene scene, PxGeometry geometry, PxTransform pose, PxVec3 unitDir, float distance, PxHitFlags outputFlags, PxSweepHit hit, PxQueryFilterData filterData, PxQueryFilterCallback filterCall) {
        return _sweepSingle(scene.getAddress(), geometry.getAddress(), pose.getAddress(), unitDir.getAddress(), distance, outputFlags.getAddress(), hit.getAddress(), filterData.getAddress(), filterCall.getAddress());
    }
    private static native boolean _sweepSingle(long scene, long geometry, long pose, long unitDir, float distance, long outputFlags, long hit, long filterData, long filterCall);

    /**
     * @param scene         WebIDL type: {@link PxScene} [Const, Ref]
     * @param geometry      WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose          WebIDL type: {@link PxTransform} [Const, Ref]
     * @param hitBuffer     WebIDL type: {@link PxOverlapHit}
     * @param hitBufferSize WebIDL type: unsigned long
     * @return WebIDL type: long
     */
    public static int overlapMultiple(PxScene scene, PxGeometry geometry, PxTransform pose, PxOverlapHit hitBuffer, int hitBufferSize) {
        return _overlapMultiple(scene.getAddress(), geometry.getAddress(), pose.getAddress(), hitBuffer.getAddress(), hitBufferSize);
    }
    private static native int _overlapMultiple(long scene, long geometry, long pose, long hitBuffer, int hitBufferSize);

    /**
     * @param scene         WebIDL type: {@link PxScene} [Const, Ref]
     * @param geometry      WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose          WebIDL type: {@link PxTransform} [Const, Ref]
     * @param hitBuffer     WebIDL type: {@link PxOverlapHit}
     * @param hitBufferSize WebIDL type: unsigned long
     * @param filterData    WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @return WebIDL type: long
     */
    public static int overlapMultiple(PxScene scene, PxGeometry geometry, PxTransform pose, PxOverlapHit hitBuffer, int hitBufferSize, PxQueryFilterData filterData) {
        return _overlapMultiple(scene.getAddress(), geometry.getAddress(), pose.getAddress(), hitBuffer.getAddress(), hitBufferSize, filterData.getAddress());
    }
    private static native int _overlapMultiple(long scene, long geometry, long pose, long hitBuffer, int hitBufferSize, long filterData);

    /**
     * @param scene         WebIDL type: {@link PxScene} [Const, Ref]
     * @param geometry      WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose          WebIDL type: {@link PxTransform} [Const, Ref]
     * @param hitBuffer     WebIDL type: {@link PxOverlapHit}
     * @param hitBufferSize WebIDL type: unsigned long
     * @param filterData    WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @param filterCall    WebIDL type: {@link PxQueryFilterCallback}
     * @return WebIDL type: long
     */
    public static int overlapMultiple(PxScene scene, PxGeometry geometry, PxTransform pose, PxOverlapHit hitBuffer, int hitBufferSize, PxQueryFilterData filterData, PxQueryFilterCallback filterCall) {
        return _overlapMultiple(scene.getAddress(), geometry.getAddress(), pose.getAddress(), hitBuffer.getAddress(), hitBufferSize, filterData.getAddress(), filterCall.getAddress());
    }
    private static native int _overlapMultiple(long scene, long geometry, long pose, long hitBuffer, int hitBufferSize, long filterData, long filterCall);

    /**
     * @param scene    WebIDL type: {@link PxScene} [Const, Ref]
     * @param geometry WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose     WebIDL type: {@link PxTransform} [Const, Ref]
     * @param hit      WebIDL type: {@link PxOverlapHit} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean overlapAny(PxScene scene, PxGeometry geometry, PxTransform pose, PxOverlapHit hit) {
        return _overlapAny(scene.getAddress(), geometry.getAddress(), pose.getAddress(), hit.getAddress());
    }
    private static native boolean _overlapAny(long scene, long geometry, long pose, long hit);

    /**
     * @param scene      WebIDL type: {@link PxScene} [Const, Ref]
     * @param geometry   WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose       WebIDL type: {@link PxTransform} [Const, Ref]
     * @param hit        WebIDL type: {@link PxOverlapHit} [Ref]
     * @param filterData WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public static boolean overlapAny(PxScene scene, PxGeometry geometry, PxTransform pose, PxOverlapHit hit, PxQueryFilterData filterData) {
        return _overlapAny(scene.getAddress(), geometry.getAddress(), pose.getAddress(), hit.getAddress(), filterData.getAddress());
    }
    private static native boolean _overlapAny(long scene, long geometry, long pose, long hit, long filterData);

    /**
     * @param scene      WebIDL type: {@link PxScene} [Const, Ref]
     * @param geometry   WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param pose       WebIDL type: {@link PxTransform} [Const, Ref]
     * @param hit        WebIDL type: {@link PxOverlapHit} [Ref]
     * @param filterData WebIDL type: {@link PxQueryFilterData} [Const, Ref]
     * @param filterCall WebIDL type: {@link PxQueryFilterCallback}
     * @return WebIDL type: boolean
     */
    public static boolean overlapAny(PxScene scene, PxGeometry geometry, PxTransform pose, PxOverlapHit hit, PxQueryFilterData filterData, PxQueryFilterCallback filterCall) {
        return _overlapAny(scene.getAddress(), geometry.getAddress(), pose.getAddress(), hit.getAddress(), filterData.getAddress(), filterCall.getAddress());
    }
    private static native boolean _overlapAny(long scene, long geometry, long pose, long hit, long filterData, long filterCall);

}
