package physx.physics;


public class SimpleQueryFilterCallback extends PxQueryFilterCallback {

    protected SimpleQueryFilterCallback() { }

    public static SimpleQueryFilterCallback wrapPointer(long address) {
        return address != 0L ? new SimpleQueryFilterCallback(address) : null;
    }
    
    protected SimpleQueryFilterCallback(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param filterData WebIDL type: {@link PxFilterData} [Const, Ref]
     * @param shape      WebIDL type: {@link PxShape} [Const]
     * @param actor      WebIDL type: {@link PxRigidActor} [Const]
     * @param queryFlags WebIDL type: {@link PxHitFlags} [Ref]
     * @return WebIDL type: unsigned long
     */
    public int simplePreFilter(PxFilterData filterData, PxShape shape, PxRigidActor actor, PxHitFlags queryFlags) {
        checkNotNull();
        return _simplePreFilter(address, filterData.getAddress(), shape.getAddress(), actor.getAddress(), queryFlags.getAddress());
    }
    private static native int _simplePreFilter(long address, long filterData, long shape, long actor, long queryFlags);

    /**
     * @param filterData WebIDL type: {@link PxFilterData} [Const, Ref]
     * @param hit        WebIDL type: {@link PxQueryHit} [Const, Ref]
     * @return WebIDL type: unsigned long
     */
    public int simplePostFilter(PxFilterData filterData, PxQueryHit hit) {
        checkNotNull();
        return _simplePostFilter(address, filterData.getAddress(), hit.getAddress());
    }
    private static native int _simplePostFilter(long address, long filterData, long hit);

}
