package physx.support;

import physx.NativeObject;

public class PxPvd extends NativeObject {

    protected PxPvd() { }

    public static PxPvd wrapPointer(long address) {
        return address != 0L ? new PxPvd(address) : null;
    }
    
    protected PxPvd(long address) {
        super(address);
    }

    // Functions

    /**
     * @param transport WebIDL type: {@link PxPvdTransport} [Ref]
     * @param flags     WebIDL type: {@link PxPvdInstrumentationFlags} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean connect(PxPvdTransport transport, PxPvdInstrumentationFlags flags) {
        checkNotNull();
        return _connect(address, transport.getAddress(), flags.getAddress());
    }
    private static native boolean _connect(long address, long transport, long flags);

}
