package physx.character;

public enum PxCapsuleClimbingModeEnum {

    /**
     * Standard mode, let the capsule climb over surfaces according to impact normal
     */
    eEASY(_geteEASY()),
    /**
     * Constrained mode, try to limit climbing according to the step offset
     */
    eCONSTRAINED(_geteCONSTRAINED());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxCapsuleClimbingModeEnum(int value) {
        this.value = value;
    }

    private static native int _geteEASY();
    private static native int _geteCONSTRAINED();
    public static PxCapsuleClimbingModeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxCapsuleClimbingModeEnum: " + value);
    }

}
