package physx.character;

/**
 * specifies controller behavior
 */
public enum PxControllerBehaviorFlagEnum {

    /**
     * Controller can ride on touched object (i.e. when this touched object is moving horizontally). <b>Note:</b> The CCT vs. CCT case is not supported.
     */
    eCCT_CAN_RIDE_ON_OBJECT(_geteCCT_CAN_RIDE_ON_OBJECT()),
    /**
     * Controller should slide on touched object
     */
    eCCT_SLIDE(_geteCCT_SLIDE()),
    eCCT_USER_DEFINED_RIDE(_geteCCT_USER_DEFINED_RIDE());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxControllerBehaviorFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteCCT_CAN_RIDE_ON_OBJECT();
    private static native int _geteCCT_SLIDE();
    private static native int _geteCCT_USER_DEFINED_RIDE();
    public static PxControllerBehaviorFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxControllerBehaviorFlagEnum: " + value);
    }

}
