package physx.character;

/**
 * specifies which sides a character is colliding with.
 */
public enum PxControllerCollisionFlagEnum {

    /**
     * Character is colliding to the sides.
     */
    eCOLLISION_SIDES(_geteCOLLISION_SIDES()),
    /**
     * Character has collision above.
     */
    eCOLLISION_UP(_geteCOLLISION_UP()),
    eCOLLISION_DOWN(_geteCOLLISION_DOWN());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxControllerCollisionFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteCOLLISION_SIDES();
    private static native int _geteCOLLISION_UP();
    private static native int _geteCOLLISION_DOWN();
    public static PxControllerCollisionFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxControllerCollisionFlagEnum: " + value);
    }

}
