package physx.character;

/**
 * The type of controller, eg box, sphere or capsule.
 */
public enum PxControllerShapeTypeEnum {

    /**
     * A box controller.
     * <p>
     * <b>See also:</b> PxBoxController PxBoxControllerDesc
     */
    eBOX(_geteBOX()),
    /**
     * A capsule controller
     * <p>
     * <b>See also:</b> PxCapsuleController PxCapsuleControllerDesc
     */
    eCAPSULE(_geteCAPSULE());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxControllerShapeTypeEnum(int value) {
        this.value = value;
    }

    private static native int _geteBOX();
    private static native int _geteCAPSULE();
    public static PxControllerShapeTypeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxControllerShapeTypeEnum: " + value);
    }

}
