package physx.common;

import physx.NativeObject;

/**
 * Cuda Context
 */
public class PxCudaContext extends NativeObject {

    protected PxCudaContext() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxCudaContext wrapPointer(long address) {
        return address != 0L ? new PxCudaContext(address) : null;
    }
    
    public static PxCudaContext arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxCudaContext(long address) {
        super(address);
    }

}
