package physx.common;

/**
 * Error codes
 * <p>
 * These error codes are passed to #PxErrorCallback
 * <p>
 * <b>See also:</b> PxErrorCallback
 */
public enum PxErrorCodeEnum {

    eNO_ERROR(_geteNO_ERROR()),
    /**
     * An informational message.
     */
    eDEBUG_INFO(_geteDEBUG_INFO()),
    /**
     * a warning message for the user to help with debugging
     */
    eDEBUG_WARNING(_geteDEBUG_WARNING()),
    /**
     * method called with invalid parameter(s)
     */
    eINVALID_PARAMETER(_geteINVALID_PARAMETER()),
    /**
     * method was called at a time when an operation is not possible
     */
    eINVALID_OPERATION(_geteINVALID_OPERATION()),
    /**
     * method failed to allocate some memory
     */
    eOUT_OF_MEMORY(_geteOUT_OF_MEMORY()),
    /**
     * The library failed for some reason.
     *    Possibly you have passed invalid values like NaNs, which are not checked for.
     */
    eINTERNAL_ERROR(_geteINTERNAL_ERROR()),
    /**
     * An unrecoverable error, execution should be halted and log output flushed
     */
    eABORT(_geteABORT()),
    /**
     * The SDK has determined that an operation may result in poor performance.
     */
    ePERF_WARNING(_getePERF_WARNING()),
    /**
     * A bit mask for including all errors
     */
    eMASK_ALL(_geteMASK_ALL());

    static {
        de.fabmax.physxjni.Loader.load();
    }
    public final int value;
    
    PxErrorCodeEnum(int value) {
        this.value = value;
    }

    private static native int _geteNO_ERROR();
    private static native int _geteDEBUG_INFO();
    private static native int _geteDEBUG_WARNING();
    private static native int _geteINVALID_PARAMETER();
    private static native int _geteINVALID_OPERATION();
    private static native int _geteOUT_OF_MEMORY();
    private static native int _geteINTERNAL_ERROR();
    private static native int _geteABORT();
    private static native int _getePERF_WARNING();
    private static native int _geteMASK_ALL();
    public static PxErrorCodeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxErrorCodeEnum: " + value);
    }

}
