package physx.common;

import physx.NativeObject;

public class PxStridedData extends NativeObject {

    protected PxStridedData() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxStridedData wrapPointer(long address) {
        return address != 0L ? new PxStridedData(address) : null;
    }
    
    public static PxStridedData arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxStridedData(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The offset in bytes between consecutive samples in the data.
     * <p>
     * <b>Default:</b> 0
     */
    public int getStride() {
        checkNotNull();
        return _getStride(address);
    }
    private static native int _getStride(long address);

    /**
     * The offset in bytes between consecutive samples in the data.
     * <p>
     * <b>Default:</b> 0
     */
    public void setStride(int value) {
        checkNotNull();
        _setStride(address, value);
    }
    private static native void _setStride(long address, int value);

    /**
     */
    public NativeObject getData() {
        checkNotNull();
        return NativeObject.wrapPointer(_getData(address));
    }
    private static native long _getData(long address);

    /**
     */
    public void setData(NativeObject value) {
        checkNotNull();
        _setData(address, value.getAddress());
    }
    private static native void _setData(long address, long value);

}
